<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetSalesHistoryQuery implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $CustomerCode;

    /**
     * @var string
     */
    private $Division;

    /**
     * @var string
     */
    private $LanguageCode;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'CustomerCode' => $this->CustomerCode,
            'Division'     => $this->Division,
            'LanguageCode' => $this->LanguageCode,
        ];
    }

    /**
     * Constructor
     *
     * @var string $CustomerCode
     * @var string $Division
     * @var string $LanguageCode
     */
    public function __construct($CustomerCode, $Division, $LanguageCode)
    {
        $this->CustomerCode = $CustomerCode;
        $this->Division = $Division;
        $this->LanguageCode = $LanguageCode;
    }

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }

    /**
     * @param string $CustomerCode
     * @return GetSalesHistoryQuery
     */
    public function withCustomerCode($CustomerCode)
    {
        $new = clone $this;
        $new->CustomerCode = $CustomerCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getDivision()
    {
        return $this->Division;
    }

    /**
     * @param string $Division
     * @return GetSalesHistoryQuery
     */
    public function withDivision($Division)
    {
        $new = clone $this;
        $new->Division = $Division;

        return $new;
    }

    /**
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }

    /**
     * @param string $LanguageCode
     * @return GetSalesHistoryQuery
     */
    public function withLanguageCode($LanguageCode)
    {
        $new = clone $this;
        $new->LanguageCode = $LanguageCode;

        return $new;
    }
}
