<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class ShipToAddress implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $Address;

    /**
     * @var string
     */
    private $Address2;

    /**
     * @var string
     */
    private $AddressType;

    /**
     * @var string
     */
    private $City;

    /**
     * @var int
     */
    private $Code;

    /**
     * @var string
     */
    private $CountryRegionCode;

    /**
     * @var string
     */
    private $Name;

    /**
     * @var string
     */
    private $PostCode;

    /**
     * @var string
     */
    private $YourReference;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'Address'           => $this->Address,
            'Address2'          => $this->Address2,
            'AddressType'       => $this->AddressType,
            'City'              => $this->City,
            'Code'              => $this->Code,
            'CountryRegionCode' => $this->CountryRegionCode,
            'Name'              => $this->Name,
            'PostCode'          => $this->PostCode,
            'YourReference'     => $this->YourReference,
        ];
    }

    /**
     * Constructor
     *
     * @var string $Address
     * @var string $Address2
     * @var string $AddressType
     * @var string $City
     * @var int $Code
     * @var string $CountryRegionCode
     * @var string $Name
     * @var string $PostCode
     * @var string $YourReference
     */
    public function __construct($Address, $Address2, $AddressType, $City, $Code, $CountryRegionCode, $Name, $PostCode, $YourReference)
    {
        $this->Address = $Address;
        $this->Address2 = $Address2;
        $this->AddressType = $AddressType;
        $this->City = $City;
        $this->Code = $Code;
        $this->CountryRegionCode = $CountryRegionCode;
        $this->Name = $Name;
        $this->PostCode = $PostCode;
        $this->YourReference = $YourReference;
    }

    /**
     * @return string
     */
    public function getAddress()
    {
        return $this->Address;
    }

    /**
     * @param string $Address
     * @return ShipToAddress
     */
    public function withAddress($Address)
    {
        $new = clone $this;
        $new->Address = $Address;

        return $new;
    }

    /**
     * @return string
     */
    public function getAddress2()
    {
        return $this->Address2;
    }

    /**
     * @param string $Address2
     * @return ShipToAddress
     */
    public function withAddress2($Address2)
    {
        $new = clone $this;
        $new->Address2 = $Address2;

        return $new;
    }

    /**
     * @return string
     */
    public function getAddressType()
    {
        return $this->AddressType;
    }

    /**
     * @param string $AddressType
     * @return ShipToAddress
     */
    public function withAddressType($AddressType)
    {
        $new = clone $this;
        $new->AddressType = $AddressType;

        return $new;
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->City;
    }

    /**
     * @param string $City
     * @return ShipToAddress
     */
    public function withCity($City)
    {
        $new = clone $this;
        $new->City = $City;

        return $new;
    }

    /**
     * @return int
     */
    public function getCode()
    {
        return $this->Code;
    }

    /**
     * @param int $Code
     * @return ShipToAddress
     */
    public function withCode($Code)
    {
        $new = clone $this;
        $new->Code = $Code;

        return $new;
    }

    /**
     * @return string
     */
    public function getCountryRegionCode()
    {
        return $this->CountryRegionCode;
    }

    /**
     * @param string $CountryRegionCode
     * @return ShipToAddress
     */
    public function withCountryRegionCode($CountryRegionCode)
    {
        $new = clone $this;
        $new->CountryRegionCode = $CountryRegionCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }

    /**
     * @param string $Name
     * @return ShipToAddress
     */
    public function withName($Name)
    {
        $new = clone $this;
        $new->Name = $Name;

        return $new;
    }

    /**
     * @return string
     */
    public function getPostCode()
    {
        return $this->PostCode;
    }

    /**
     * @param string $PostCode
     * @return ShipToAddress
     */
    public function withPostCode($PostCode)
    {
        $new = clone $this;
        $new->PostCode = $PostCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getYourReference()
    {
        return $this->YourReference;
    }

    /**
     * @param string $YourReference
     * @return ShipToAddress
     */
    public function withYourReference($YourReference)
    {
        $new = clone $this;
        $new->YourReference = $YourReference;

        return $new;
    }
}
