<?php

namespace MSML\BizTalk\Type\BottleOrder;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class CollectFaulty implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $itemNo;

    /**
     * @var float
     */
    private $quantity;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'itemNo'   => $this->itemNo,
            'quantity' => $this->quantity,
        ];
    }

    /**
     * Constructor
     *
     * @var string $itemNo
     * @var float $quantity
     */
    public function __construct($itemNo, $quantity)
    {
        $this->itemNo = $itemNo;
        $this->quantity = $quantity;
    }

    /**
     * @return string
     */
    public function getItemNo()
    {
        return $this->itemNo;
    }

    /**
     * @param string $itemNo
     * @return CollectFaulty
     */
    public function withItemNo($itemNo)
    {
        $new = clone $this;
        $new->itemNo = $itemNo;

        return $new;
    }

    /**
     * @return float
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * @param float $quantity
     * @return CollectFaulty
     */
    public function withQuantity($quantity)
    {
        $new = clone $this;
        $new->quantity = $quantity;

        return $new;
    }
}
