<?php

namespace MSML\BizTalk\Type\BottleOrder;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class OrderLine implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $itemNo;

    /**
     * @var float
     */
    private $quantity;

    /**
     * @var \MSML\BizTalk\Type\BottleOrder\collectEmpty
     */
    private $collectEmpty;

    /**
     * @var \MSML\BizTalk\Type\BottleOrder\collectFaulty
     */
    private $collectFaulty;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'itemNo'        => $this->itemNo,
            'quantity'      => $this->quantity,
            'collectEmpty'  => $this->collectEmpty,
            'collectFaulty' => $this->collectFaulty,
        ];
    }

    /**
     * Constructor
     *
     * @var string $itemNo
     * @var float $quantity
     * @var \MSML\BizTalk\Type\BottleOrder\collectEmpty $collectEmpty
     * @var \MSML\BizTalk\Type\BottleOrder\collectFaulty $collectFaulty
     */
    public function __construct($itemNo, $quantity, $collectEmpty, $collectFaulty)
    {
        $this->itemNo = $itemNo;
        $this->quantity = $quantity;
        $this->collectEmpty = $collectEmpty;
        $this->collectFaulty = $collectFaulty;
    }

    /**
     * @return string
     */
    public function getItemNo()
    {
        return $this->itemNo;
    }

    /**
     * @param string $itemNo
     * @return OrderLine
     */
    public function withItemNo($itemNo)
    {
        $new = clone $this;
        $new->itemNo = $itemNo;

        return $new;
    }

    /**
     * @return float
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * @param float $quantity
     * @return OrderLine
     */
    public function withQuantity($quantity)
    {
        $new = clone $this;
        $new->quantity = $quantity;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\BottleOrder\collectEmpty
     */
    public function getCollectEmpty()
    {
        return $this->collectEmpty;
    }

    /**
     * @param \MSML\BizTalk\Type\BottleOrder\collectEmpty $collectEmpty
     * @return OrderLine
     */
    public function withCollectEmpty($collectEmpty)
    {
        $new = clone $this;
        $new->collectEmpty = $collectEmpty;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\BottleOrder\collectFaulty
     */
    public function getCollectFaulty()
    {
        return $this->collectFaulty;
    }

    /**
     * @param \MSML\BizTalk\Type\BottleOrder\collectFaulty $collectFaulty
     * @return OrderLine
     */
    public function withCollectFaulty($collectFaulty)
    {
        $new = clone $this;
        $new->collectFaulty = $collectFaulty;

        return $new;
    }
}
