<?php

namespace MSML\BizTalk\Type\ShippingContact;

use JsonSerializable;
use Phpro\SoapClient\Type\ResultInterface;

class RegisterShippingContactResponse implements JsonSerializable, ResultInterface
{
    /**
     * @var string
     */
    private $ContactRef;

    /**
     * @var string
     */
    private $ErrorCode;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'ContactRef'   => $this->ContactRef,
            'ErrorCode'    => $this->ErrorCode,
            'ErrorMessage' => $this->ErrorMessage,
        ];
    }

    /**
     * @return string
     */
    public function getContactRef()
    {
        return $this->ContactRef;
    }

    /**
     * @param string $ContactRef
     * @return RegisterShippingContactResponse
     */
    public function withContactRef($ContactRef)
    {
        $new = clone $this;
        $new->ContactRef = $ContactRef;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }

    /**
     * @param string $ErrorCode
     * @return RegisterShippingContactResponse
     */
    public function withErrorCode($ErrorCode)
    {
        $new = clone $this;
        $new->ErrorCode = $ErrorCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return RegisterShippingContactResponse
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }
}
