<?php

namespace MSML\BizTalk;

use MSML\BizTalk\Client\Base\BizTalkBaseClient;
use MSML\BizTalk\Client\Order\BizTalkOrderClient;
use MSML\BizTalk\ClassMap\Base\BizTalkBaseClassMap;
use MSML\BizTalk\ClassMap\Order\BizTalkOrderClassMap;
use MSML\BizTalk\Client\Contact\BizTalkContactClient;
use Symfony\Component\EventDispatcher\EventDispatcher;
use Phpro\SoapClient\Soap\Driver\ExtSoap\ExtSoapOptions;
use MSML\BizTalk\ClassMap\Contact\BizTalkContactClassMap;
use MSML\BizTalk\Client\BottleOrder\BizTalkBottleOrderClient;
use Phpro\SoapClient\Soap\Driver\ExtSoap\ExtSoapEngineFactory;
use MSML\BizTalk\ClassMap\BottleOrder\BizTalkBottleOrderClassMap;
use MSML\BizTalk\Client\GasMeterScore\BizTalkGasMeterScoreClient;
use MSML\BizTalk\Client\MaterialOrder\BizTalkMaterialOrderClient;
use MSML\BizTalk\Client\PrimaryContact\BizTalkPrimaryContactClient;
use MSML\BizTalk\ClassMap\GasMeterScore\BizTalkGasMeterScoreClassMap;
use MSML\BizTalk\ClassMap\MaterialOrder\BizTalkMaterialOrderClassMap;
use MSML\BizTalk\Client\ShippingContact\BizTalkShippingContactClient;
use MSML\BizTalk\ClassMap\PrimaryContact\BizTalkPrimaryContactClassMap;
use MSML\BizTalk\ClassMap\ShippingContact\BizTalkShippingContactClassMap;

class BizTalkClientFactory
{
    public static function base(string $wsdl): \MSML\BizTalk\Client\Base\BizTalkBaseClient
    {
        $engine = ExtSoapEngineFactory::fromOptions(
            ExtSoapOptions::defaults($wsdl, config('biztalk.options', []))
                ->withClassMap(BizTalkBaseClassMap::getCollection())
        );
        $eventDispatcher = new EventDispatcher();

        return new BizTalkBaseClient($engine, $eventDispatcher);
    }

    public static function order(string $wsdl): \MSML\BizTalk\Client\Order\BizTalkOrderClient
    {
        $engine = ExtSoapEngineFactory::fromOptions(
            ExtSoapOptions::defaults($wsdl, config('biztalk.options', []))
                ->withClassMap(BizTalkOrderClassMap::getCollection())
        );
        $eventDispatcher = new EventDispatcher();

        return new BizTalkOrderClient($engine, $eventDispatcher);
    }

    public static function contact(string $wsdl): \MSML\BizTalk\Client\Contact\BizTalkContactClient
    {
        $engine = ExtSoapEngineFactory::fromOptions(
            ExtSoapOptions::defaults($wsdl, config('biztalk.options', []))
                ->withClassMap(BizTalkContactClassMap::getCollection())
        );
        $eventDispatcher = new EventDispatcher();

        return new BizTalkContactClient($engine, $eventDispatcher);
    }

    public static function primaryContact(string $wsdl): \MSML\BizTalk\Client\PrimaryContact\BizTalkPrimaryContactClient
    {
        $engine = ExtSoapEngineFactory::fromOptions(
            ExtSoapOptions::defaults($wsdl, config('biztalk.options', []))
                ->withClassMap(BizTalkPrimaryContactClassMap::getCollection())
        );
        $eventDispatcher = new EventDispatcher();

        return new BizTalkPrimaryContactClient($engine, $eventDispatcher);
    }

    public static function shippingContact(string $wsdl): \MSML\BizTalk\Client\ShippingContact\BizTalkShippingContactClient
    {
        $engine = ExtSoapEngineFactory::fromOptions(
            ExtSoapOptions::defaults($wsdl, config('biztalk.options', []))
                ->withClassMap(BizTalkShippingContactClassMap::getCollection())
        );
        $eventDispatcher = new EventDispatcher();

        return new BizTalkShippingContactClient($engine, $eventDispatcher);
    }

    public static function materialOrder(string $wsdl): \MSML\BizTalk\Client\MaterialOrder\BizTalkMaterialOrderClient
    {
        $engine = ExtSoapEngineFactory::fromOptions(
            ExtSoapOptions::defaults($wsdl, config('biztalk.options', []))
                ->withClassMap(BizTalkMaterialOrderClassMap::getCollection())
        );
        $eventDispatcher = new EventDispatcher();

        return new BizTalkMaterialOrderClient($engine, $eventDispatcher);
    }

    public static function bottleOrder(string $wsdl): \MSML\BizTalk\Client\BottleOrder\BizTalkBottleOrderClient
    {
        $engine = ExtSoapEngineFactory::fromOptions(
            ExtSoapOptions::defaults($wsdl, config('biztalk.options', []))
                ->withClassMap(BizTalkBottleOrderClassMap::getCollection())
        );
        $eventDispatcher = new EventDispatcher();

        return new BizTalkBottleOrderClient($engine, $eventDispatcher);
    }

    public static function gasMeterScore(string $wsdl): \MSML\BizTalk\Client\GasMeterScore\BizTalkGasMeterScoreClient
    {
        $engine = ExtSoapEngineFactory::fromOptions(
            ExtSoapOptions::defaults($wsdl, config('biztalk.options', []))
                ->withClassMap(BizTalkGasMeterScoreClassMap::getCollection())
        );
        $eventDispatcher = new EventDispatcher();

        return new BizTalkGasMeterScoreClient($engine, $eventDispatcher);
    }
}
