<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class ArrayOfCustomerLedgerEntry implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\CustomerLedgerEntry
     */
    private $CustomerLedgerEntry;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'CustomerLedgerEntry' => $this->CustomerLedgerEntry,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\CustomerLedgerEntry $CustomerLedgerEntry
     */
    public function __construct($CustomerLedgerEntry)
    {
        $this->CustomerLedgerEntry = $CustomerLedgerEntry;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\CustomerLedgerEntry
     */
    public function getCustomerLedgerEntry()
    {
        return $this->CustomerLedgerEntry;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\CustomerLedgerEntry $CustomerLedgerEntry
     * @return ArrayOfCustomerLedgerEntry
     */
    public function withCustomerLedgerEntry($CustomerLedgerEntry)
    {
        $new = clone $this;
        $new->CustomerLedgerEntry = $CustomerLedgerEntry;

        return $new;
    }
}
