<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class ArrayOfOrderHistoryItem implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\OrderHistoryItem
     */
    private $OrderHistoryItem;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'OrderHistoryItem' => $this->OrderHistoryItem,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\OrderHistoryItem $OrderHistoryItem
     */
    public function __construct($OrderHistoryItem)
    {
        $this->OrderHistoryItem = $OrderHistoryItem;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\OrderHistoryItem
     */
    public function getOrderHistoryItem()
    {
        return $this->OrderHistoryItem;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\OrderHistoryItem $OrderHistoryItem
     * @return ArrayOfOrderHistoryItem
     */
    public function withOrderHistoryItem($OrderHistoryItem)
    {
        $new = clone $this;
        $new->OrderHistoryItem = $OrderHistoryItem;

        return $new;
    }
}
