<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class ArrayOfServiceItem implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\ServiceItem
     */
    private $ServiceItem;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'ServiceItem' => $this->ServiceItem,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\ServiceItem $ServiceItem
     */
    public function __construct($ServiceItem)
    {
        $this->ServiceItem = $ServiceItem;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\ServiceItem
     */
    public function getServiceItem()
    {
        return $this->ServiceItem;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\ServiceItem $ServiceItem
     * @return ArrayOfServiceItem
     */
    public function withServiceItem($ServiceItem)
    {
        $new = clone $this;
        $new->ServiceItem = $ServiceItem;

        return $new;
    }
}
