<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class CustomerData implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $Address;

    /**
     * @var string
     */
    private $Address2;

    /**
     * @var string
     */
    private $City;

    /**
     * @var string
     */
    private $CountryRegionCode;

    /**
     * @var string
     */
    private $Name;

    /**
     * @var string
     */
    private $No;

    /**
     * @var string
     */
    private $PaymentMethod;

    /**
     * @var string
     */
    private $PostCode;

    /**
     * @var string
     */
    private $PreferredBankAccount;

    /**
     * @var \MSML\BizTalk\Type\Base\ArrayOfShipToAddress
     */
    private $ShipToAddresses;

    /**
     * @var number
     */
    private $AdvancedPaymentAmount;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'Address'               => $this->Address,
            'Address2'              => $this->Address2,
            'City'                  => $this->City,
            'CountryRegionCode'     => $this->CountryRegionCode,
            'Name'                  => $this->Name,
            'No'                    => $this->No,
            'PaymentMethod'         => $this->PaymentMethod,
            'PostCode'              => $this->PostCode,
            'PreferredBankAccount'  => $this->PreferredBankAccount,
            'ShipToAddresses'       => $this->ShipToAddresses,
            'AdvancedPaymentAmount' => $this->AdvancedPaymentAmount,
        ];
    }

    /**
     * Constructor
     *
     * @var string $Address
     * @var string $Address2
     * @var string $City
     * @var string $CountryRegionCode
     * @var string $Name
     * @var string $No
     * @var string $PaymentMethod
     * @var string $PostCode
     * @var string $PreferredBankAccount
     * @var \MSML\BizTalk\Type\Base\ArrayOfShipToAddress $ShipToAddresses
     * @var string $AdvancedPaymentAmount
     */
    public function __construct($Address, $Address2, $City, $CountryRegionCode, $Name, $No, $PaymentMethod, $PostCode, $PreferredBankAccount, $ShipToAddresses, $AdvancedPaymentAmount)
    {
        $this->Address = $Address;
        $this->Address2 = $Address2;
        $this->City = $City;
        $this->CountryRegionCode = $CountryRegionCode;
        $this->Name = $Name;
        $this->No = $No;
        $this->PaymentMethod = $PaymentMethod;
        $this->PostCode = $PostCode;
        $this->PreferredBankAccount = $PreferredBankAccount;
        $this->ShipToAddresses = $ShipToAddresses;
        $this->AdvancedPaymentAmount = $AdvancedPaymentAmount;
    }

    /**
     * @return string
     */
    public function getAddress()
    {
        return $this->Address;
    }

    /**
     * @param string $Address
     * @return CustomerData
     */
    public function withAddress($Address)
    {
        $new = clone $this;
        $new->Address = $Address;

        return $new;
    }

    /**
     * @return string
     */
    public function getAddress2()
    {
        return $this->Address2;
    }

    /**
     * @param string $Address2
     * @return CustomerData
     */
    public function withAddress2($Address2)
    {
        $new = clone $this;
        $new->Address2 = $Address2;

        return $new;
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->City;
    }

    /**
     * @param string $City
     * @return CustomerData
     */
    public function withCity($City)
    {
        $new = clone $this;
        $new->City = $City;

        return $new;
    }

    /**
     * @return string
     */
    public function getCountryRegionCode()
    {
        return $this->CountryRegionCode;
    }

    /**
     * @param string $CountryRegionCode
     * @return CustomerData
     */
    public function withCountryRegionCode($CountryRegionCode)
    {
        $new = clone $this;
        $new->CountryRegionCode = $CountryRegionCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }

    /**
     * @param string $Name
     * @return CustomerData
     */
    public function withName($Name)
    {
        $new = clone $this;
        $new->Name = $Name;

        return $new;
    }

    /**
     * @return string
     */
    public function getNo()
    {
        return $this->No;
    }

    /**
     * @param string $No
     * @return CustomerData
     */
    public function withNo($No)
    {
        $new = clone $this;
        $new->No = $No;

        return $new;
    }

    /**
     * @return string
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }

    /**
     * @param string $PaymentMethod
     * @return CustomerData
     */
    public function withPaymentMethod($PaymentMethod)
    {
        $new = clone $this;
        $new->PaymentMethod = $PaymentMethod;

        return $new;
    }

    /**
     * @return string
     */
    public function getPostCode()
    {
        return $this->PostCode;
    }

    /**
     * @param string $PostCode
     * @return CustomerData
     */
    public function withPostCode($PostCode)
    {
        $new = clone $this;
        $new->PostCode = $PostCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getPreferredBankAccount()
    {
        return $this->PreferredBankAccount;
    }

    /**
     * @param string $PreferredBankAccount
     * @return CustomerData
     */
    public function withPreferredBankAccount($PreferredBankAccount)
    {
        $new = clone $this;
        $new->PreferredBankAccount = $PreferredBankAccount;

        return $new;
    }

    /**
     * @return string
     */
    public function getAdvancedPaymentAmount()
    {
        return $this->AdvancedPaymentAmount;
    }

    /**
     * @param string $AdvancedPaymentAmount
     * @return CustomerData
     */
    public function withAdvancedPaymentAmount($AdvancedPaymentAmount)
    {
        $new = clone $this;
        $new->AdvancedPaymentAmount = $AdvancedPaymentAmount;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\ArrayOfShipToAddress
     */
    public function getShipToAddresses()
    {
        return $this->ShipToAddresses;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\ArrayOfShipToAddress $ShipToAddresses
     * @return CustomerData
     */
    public function withShipToAddresses($ShipToAddresses)
    {
        $new = clone $this;
        $new->ShipToAddresses = $ShipToAddresses;

        return $new;
    }
}
