<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class FuelTankResult implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var \MSML\BizTalk\Type\Base\DRRException
     */
    private $Exception;

    /**
     * @var \MSML\BizTalk\Type\Base\ArrayOfFuelTankResult.FuelTank
     */
    private $FuelTanks;

    /**
     * @var string
     */
    private $ReturnCode;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'ErrorMessage' => $this->ErrorMessage,
            'Exception'    => $this->Exception,
            'FuelTanks'    => $this->FuelTanks,
            'ReturnCode'   => $this->ReturnCode,
        ];
    }

    /**
     * Constructor
     *
     * @var string $ErrorMessage
     * @var \MSML\BizTalk\Type\Base\DRRException $Exception
     * @var \MSML\BizTalk\Type\Base\ArrayOfFuelTankResult.FuelTank $FuelTanks
     * @var string $ReturnCode
     */
    public function __construct($ErrorMessage, $Exception, $FuelTanks, $ReturnCode)
    {
        $this->ErrorMessage = $ErrorMessage;
        $this->Exception = $Exception;
        $this->FuelTanks = $FuelTanks;
        $this->ReturnCode = $ReturnCode;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return FuelTankResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\DRRException
     */
    public function getException()
    {
        return $this->Exception;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\DRRException $Exception
     * @return FuelTankResult
     */
    public function withException($Exception)
    {
        $new = clone $this;
        $new->Exception = $Exception;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\ArrayOfFuelTankResult.FuelTank
     */
    public function getFuelTanks()
    {
        return $this->FuelTanks;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\ArrayOfFuelTankResult.FuelTank $FuelTanks
     * @return FuelTankResult
     */
    public function withFuelTanks($FuelTanks)
    {
        $new = clone $this;
        $new->FuelTanks = $FuelTanks;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }

    /**
     * @param string $ReturnCode
     * @return FuelTankResult
     */
    public function withReturnCode($ReturnCode)
    {
        $new = clone $this;
        $new->ReturnCode = $ReturnCode;

        return $new;
    }
}
