<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class FuelTankResultFuelTank implements JsonSerializable, RequestInterface
{
    /**
     * @var float
     */
    private $Capacity;

    /**
     * @var string
     */
    private $ItemDescription;

    /**
     * @var string
     */
    private $ItemNo;

    /**
     * @var float
     */
    private $MaxFillingLevelPercentage;

    /**
     * @var string
     */
    private $ServiceItemNoTelemetry;

    /**
     * @var string
     */
    private $ShipToAddressCode;

    /**
     * @var string
     */
    private $TankNo;

    /**
     * @var string
     */
    private $TankSerialNo;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'Capacity'                  => $this->Capacity,
            'ItemDescription'           => $this->ItemDescription,
            'ItemNo'                    => $this->ItemNo,
            'MaxFillingLevelPercentage' => $this->MaxFillingLevelPercentage,
            'ServiceItemNoTelemetry'    => $this->ServiceItemNoTelemetry,
            'ShipToAddressCode'         => $this->ShipToAddressCode,
            'TankNo'                    => $this->TankNo,
            'TankSerialNo'              => $this->TankSerialNo,
        ];
    }

    /**
     * Constructor
     *
     * @var float $Capacity
     * @var string $ItemDescription
     * @var string $ItemNo
     * @var float $MaxFillingLevelPercentage
     * @var string $ServiceItemNoTelemetry
     * @var string $ShipToAddressCode
     * @var string $TankNo
     * @var string $TankSerialNo
     */
    public function __construct($Capacity, $ItemDescription, $ItemNo, $MaxFillingLevelPercentage, $ServiceItemNoTelemetry, $ShipToAddressCode, $TankNo, $TankSerialNo)
    {
        $this->Capacity = $Capacity;
        $this->ItemDescription = $ItemDescription;
        $this->ItemNo = $ItemNo;
        $this->MaxFillingLevelPercentage = $MaxFillingLevelPercentage;
        $this->ServiceItemNoTelemetry = $ServiceItemNoTelemetry;
        $this->ShipToAddressCode = $ShipToAddressCode;
        $this->TankNo = $TankNo;
        $this->TankSerialNo = $TankSerialNo;
    }

    /**
     * @return float
     */
    public function getCapacity()
    {
        return $this->Capacity;
    }

    /**
     * @param float $Capacity
     * @return FuelTankResultFuelTank
     */
    public function withCapacity($Capacity)
    {
        $new = clone $this;
        $new->Capacity = $Capacity;

        return $new;
    }

    /**
     * @return string
     */
    public function getItemDescription()
    {
        return $this->ItemDescription;
    }

    /**
     * @param string $ItemDescription
     * @return FuelTankResultFuelTank
     */
    public function withItemDescription($ItemDescription)
    {
        $new = clone $this;
        $new->ItemDescription = $ItemDescription;

        return $new;
    }

    /**
     * @return string
     */
    public function getItemNo()
    {
        return $this->ItemNo;
    }

    /**
     * @param string $ItemNo
     * @return FuelTankResultFuelTank
     */
    public function withItemNo($ItemNo)
    {
        $new = clone $this;
        $new->ItemNo = $ItemNo;

        return $new;
    }

    /**
     * @return float
     */
    public function getMaxFillingLevelPercentage()
    {
        return $this->MaxFillingLevelPercentage;
    }

    /**
     * @param float $MaxFillingLevelPercentage
     * @return FuelTankResultFuelTank
     */
    public function withMaxFillingLevelPercentage($MaxFillingLevelPercentage)
    {
        $new = clone $this;
        $new->MaxFillingLevelPercentage = $MaxFillingLevelPercentage;

        return $new;
    }

    /**
     * @return string
     */
    public function getServiceItemNoTelemetry()
    {
        return $this->ServiceItemNoTelemetry;
    }

    /**
     * @param string $ServiceItemNoTelemetry
     * @return FuelTankResultFuelTank
     */
    public function withServiceItemNoTelemetry($ServiceItemNoTelemetry)
    {
        $new = clone $this;
        $new->ServiceItemNoTelemetry = $ServiceItemNoTelemetry;

        return $new;
    }

    /**
     * @return string
     */
    public function getShipToAddressCode()
    {
        return $this->ShipToAddressCode;
    }

    /**
     * @param string $ShipToAddressCode
     * @return FuelTankResultFuelTank
     */
    public function withShipToAddressCode($ShipToAddressCode)
    {
        $new = clone $this;
        $new->ShipToAddressCode = $ShipToAddressCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getTankNo()
    {
        return $this->TankNo;
    }

    /**
     * @param string $TankNo
     * @return FuelTankResultFuelTank
     */
    public function withTankNo($TankNo)
    {
        $new = clone $this;
        $new->TankNo = $TankNo;

        return $new;
    }

    /**
     * @return string
     */
    public function getTankSerialNo()
    {
        return $this->TankSerialNo;
    }

    /**
     * @param string $TankSerialNo
     * @return FuelTankResultFuelTank
     */
    public function withTankSerialNo($TankSerialNo)
    {
        $new = clone $this;
        $new->TankSerialNo = $TankSerialNo;

        return $new;
    }
}
