<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetCustomerLedgerEntryResult implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $CustomerCode;

    /**
     * @var \MSML\BizTalk\Type\Base\ArrayOfCustomerLedgerEntry
     */
    private $CustomerLedgerEntry;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var string
     */
    private $ReturnCode;

    /**
     * @var \DateTime
     */
    private $StartDate;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'CustomerCode'        => $this->CustomerCode,
            'CustomerLedgerEntry' => $this->CustomerLedgerEntry,
            'ErrorMessage'        => $this->ErrorMessage,
            'ReturnCode'          => $this->ReturnCode,
            'StartDate'           => $this->StartDate,
        ];
    }

    /**
     * Constructor
     *
     * @var string $CustomerCode
     * @var \MSML\BizTalk\Type\Base\ArrayOfCustomerLedgerEntry $CustomerLedgerEntry
     * @var string $ErrorMessage
     * @var string $ReturnCode
     * @var \DateTime $StartDate
     */
    public function __construct($CustomerCode, $CustomerLedgerEntry, $ErrorMessage, $ReturnCode, $StartDate)
    {
        $this->CustomerCode = $CustomerCode;
        $this->CustomerLedgerEntry = $CustomerLedgerEntry;
        $this->ErrorMessage = $ErrorMessage;
        $this->ReturnCode = $ReturnCode;
        $this->StartDate = $StartDate;
    }

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }

    /**
     * @param string $CustomerCode
     * @return GetCustomerLedgerEntryResult
     */
    public function withCustomerCode($CustomerCode)
    {
        $new = clone $this;
        $new->CustomerCode = $CustomerCode;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\ArrayOfCustomerLedgerEntry
     */
    public function getCustomerLedgerEntry()
    {
        return $this->CustomerLedgerEntry;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\ArrayOfCustomerLedgerEntry $CustomerLedgerEntry
     * @return GetCustomerLedgerEntryResult
     */
    public function withCustomerLedgerEntry($CustomerLedgerEntry)
    {
        $new = clone $this;
        $new->CustomerLedgerEntry = $CustomerLedgerEntry;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetCustomerLedgerEntryResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }

    /**
     * @param string $ReturnCode
     * @return GetCustomerLedgerEntryResult
     */
    public function withReturnCode($ReturnCode)
    {
        $new = clone $this;
        $new->ReturnCode = $ReturnCode;

        return $new;
    }

    /**
     * @return \DateTime
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }

    /**
     * @param \DateTime $StartDate
     * @return GetCustomerLedgerEntryResult
     */
    public function withStartDate($StartDate)
    {
        $new = clone $this;
        $new->StartDate = $StartDate;

        return $new;
    }
}
