<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetInvoiceDetailsResult implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var \MSML\BizTalk\Type\Base\DRRException
     */
    private $Exception;

    /**
     * @var \MSML\BizTalk\Type\Base\ArrayOfInvoiceLine
     */
    private $InvoiceLines;

    /**
     * @var string
     */
    private $InvoiceNumber;

    /**
     * @var string
     */
    private $RemainingAmount;

    /**
     * @var string
     */
    private $ReminderTermsCode;

    /**
     * @var string
     */
    private $ReturnCode;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'ErrorMessage'      => $this->ErrorMessage,
            'Exception'         => $this->Exception,
            'InvoiceLines'      => $this->InvoiceLines,
            'InvoiceNumber'     => $this->InvoiceNumber,
            'RemainingAmount'   => $this->RemainingAmount,
            'ReturnCode'        => $this->ReturnCode,
            'ReminderTermsCode' => $this->ReminderTermsCode,
        ];
    }

    /**
     * Constructor
     *
     * @var string $ErrorMessage
     * @var \MSML\BizTalk\Type\Base\DRRException $Exception
     * @var \MSML\BizTalk\Type\Base\ArrayOfInvoiceLine $InvoiceLines
     * @var string $InvoiceNumber
     * @var string $RemainingAmount
     * @var string $ReturnCode
     */
    public function __construct($ErrorMessage, $Exception, $InvoiceLines, $InvoiceNumber, $RemainingAmount, $ReminderTermsCode, $ReturnCode)
    {
        $this->ErrorMessage = $ErrorMessage;
        $this->Exception = $Exception;
        $this->InvoiceLines = $InvoiceLines;
        $this->InvoiceNumber = $InvoiceNumber;
        $this->RemainingAmount = $RemainingAmount;
        $this->ReminderTermsCode = $ReminderTermsCode;
        $this->ReturnCode = $ReturnCode;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetInvoiceDetailsResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\DRRException
     */
    public function getException()
    {
        return $this->Exception;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\DRRException $Exception
     * @return GetInvoiceDetailsResult
     */
    public function withException($Exception)
    {
        $new = clone $this;
        $new->Exception = $Exception;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\ArrayOfInvoiceLine
     */
    public function getInvoiceLines()
    {
        return $this->InvoiceLines;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\ArrayOfInvoiceLine $InvoiceLines
     * @return GetInvoiceDetailsResult
     */
    public function withInvoiceLines($InvoiceLines)
    {
        $new = clone $this;
        $new->InvoiceLines = $InvoiceLines;

        return $new;
    }

    /**
     * @return string
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }

    /**
     * @param string $InvoiceNumber
     * @return GetInvoiceDetailsResult
     */
    public function withInvoiceNumber($InvoiceNumber)
    {
        $new = clone $this;
        $new->InvoiceNumber = $InvoiceNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getRemainingAmount()
    {
        return $this->RemainingAmount;
    }

    /**
     * @param string $RemainingAmount
     * @return GetInvoiceDetailsResult
     */
    public function withRemainingAmount($RemainingAmount)
    {
        $new = clone $this;
        $new->RemainingAmount = $RemainingAmount;

        return $new;
    }

    /**
     * @return string
     */
    public function getReminderTermsCode()
    {
        return $this->ReminderTermsCode;
    }

    /**
     * @param string $ReminderTermsCode
     * @return GetInvoiceDetailsResult
     */
    public function withReminderTermsCode($ReminderTermsCode)
    {
        $new = clone $this;
        $new->ReminderTermsCode = $ReminderTermsCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }

    /**
     * @param string $ReturnCode
     * @return GetInvoiceDetailsResult
     */
    public function withReturnCode($ReturnCode)
    {
        $new = clone $this;
        $new->ReturnCode = $ReturnCode;

        return $new;
    }
}
