<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetOrderHistory implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\GetOrderHistoryQuery
     */
    private $request;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'request' => $this->request,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\GetOrderHistoryQuery $request
     */
    public function __construct($request)
    {
        $this->request = $request;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\GetOrderHistoryQuery
     */
    public function getRequest()
    {
        return $this->request;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\GetOrderHistoryQuery $request
     * @return GetOrderHistory
     */
    public function withRequest($request)
    {
        $new = clone $this;
        $new->request = $request;

        return $new;
    }
}
