<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GetOrderHistoryResult implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $CustomerCode;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var \MSML\BizTalk\Type\Base\DRRException
     */
    private $Exception;

    /**
     * @var \MSML\BizTalk\Type\Base\ArrayOfOrderHistoryItem
     */
    private $Items;

    /**
     * @var string
     */
    private $LanguageCode;

    /**
     * @var int
     */
    private $NumberOfPeriods;

    /**
     * @var string
     */
    private $ReturnCode;

    /**
     * @var \DateTime
     */
    private $StartDate;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'CustomerCode'    => $this->CustomerCode,
            'ErrorMessage'    => $this->ErrorMessage,
            'Exception'       => $this->Exception,
            'Items'           => $this->Items,
            'LanguageCode'    => $this->LanguageCode,
            'NumberOfPeriods' => $this->NumberOfPeriods,
            'ReturnCode'      => $this->ReturnCode,
            'StartDate'       => $this->StartDate,
        ];
    }

    /**
     * Constructor
     *
     * @var string $CustomerCode
     * @var string $ErrorMessage
     * @var \MSML\BizTalk\Type\Base\DRRException $Exception
     * @var \MSML\BizTalk\Type\Base\ArrayOfOrderHistoryItem $Items
     * @var string $LanguageCode
     * @var int $NumberOfPeriods
     * @var string $ReturnCode
     * @var \DateTime $StartDate
     */
    public function __construct($CustomerCode, $ErrorMessage, $Exception, $Items, $LanguageCode, $NumberOfPeriods, $ReturnCode, $StartDate)
    {
        $this->CustomerCode = $CustomerCode;
        $this->ErrorMessage = $ErrorMessage;
        $this->Exception = $Exception;
        $this->Items = $Items;
        $this->LanguageCode = $LanguageCode;
        $this->NumberOfPeriods = $NumberOfPeriods;
        $this->ReturnCode = $ReturnCode;
        $this->StartDate = $StartDate;
    }

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }

    /**
     * @param string $CustomerCode
     * @return GetOrderHistoryResult
     */
    public function withCustomerCode($CustomerCode)
    {
        $new = clone $this;
        $new->CustomerCode = $CustomerCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetOrderHistoryResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\DRRException
     */
    public function getException()
    {
        return $this->Exception;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\DRRException $Exception
     * @return GetOrderHistoryResult
     */
    public function withException($Exception)
    {
        $new = clone $this;
        $new->Exception = $Exception;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\ArrayOfOrderHistoryItem
     */
    public function getItems()
    {
        return $this->Items;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\ArrayOfOrderHistoryItem $Items
     * @return GetOrderHistoryResult
     */
    public function withItems($Items)
    {
        $new = clone $this;
        $new->Items = $Items;

        return $new;
    }

    /**
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }

    /**
     * @param string $LanguageCode
     * @return GetOrderHistoryResult
     */
    public function withLanguageCode($LanguageCode)
    {
        $new = clone $this;
        $new->LanguageCode = $LanguageCode;

        return $new;
    }

    /**
     * @return int
     */
    public function getNumberOfPeriods()
    {
        return $this->NumberOfPeriods;
    }

    /**
     * @param int $NumberOfPeriods
     * @return GetOrderHistoryResult
     */
    public function withNumberOfPeriods($NumberOfPeriods)
    {
        $new = clone $this;
        $new->NumberOfPeriods = $NumberOfPeriods;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }

    /**
     * @param string $ReturnCode
     * @return GetOrderHistoryResult
     */
    public function withReturnCode($ReturnCode)
    {
        $new = clone $this;
        $new->ReturnCode = $ReturnCode;

        return $new;
    }

    /**
     * @return \DateTime
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }

    /**
     * @param \DateTime $StartDate
     * @return GetOrderHistoryResult
     */
    public function withStartDate($StartDate)
    {
        $new = clone $this;
        $new->StartDate = $StartDate;

        return $new;
    }
}
