<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class Sales implements JsonSerializable, RequestInterface
{
    /**
     * @var float
     */
    private $QtyBaseUOM;

    /**
     * @var float
     */
    private $QtySalesUOM;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'QtyBaseUOM'  => $this->QtyBaseUOM,
            'QtySalesUOM' => $this->QtySalesUOM,
        ];
    }

    /**
     * Constructor
     *
     * @var float $QtyBaseUOM
     * @var float $QtySalesUOM
     */
    public function __construct($QtyBaseUOM, $QtySalesUOM)
    {
        $this->QtyBaseUOM = $QtyBaseUOM;
        $this->QtySalesUOM = $QtySalesUOM;
    }

    /**
     * @return float
     */
    public function getQtyBaseUOM()
    {
        return $this->QtyBaseUOM;
    }

    /**
     * @param float $QtyBaseUOM
     * @return Sales
     */
    public function withQtyBaseUOM($QtyBaseUOM)
    {
        $new = clone $this;
        $new->QtyBaseUOM = $QtyBaseUOM;

        return $new;
    }

    /**
     * @return float
     */
    public function getQtySalesUOM()
    {
        return $this->QtySalesUOM;
    }

    /**
     * @param float $QtySalesUOM
     * @return Sales
     */
    public function withQtySalesUOM($QtySalesUOM)
    {
        $new = clone $this;
        $new->QtySalesUOM = $QtySalesUOM;

        return $new;
    }
}
