<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class SalesHistoryItem implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $BaseUOM;

    /**
     * @var string
     */
    private $Description;

    /**
     * @var string
     */
    private $No;

    /**
     * @var \MSML\BizTalk\Type\Base\ArrayOfSalesHistoryItemPeriod
     */
    private $Period;

    /**
     * @var string
     */
    private $SalesUOM;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'BaseUOM'     => $this->BaseUOM,
            'Description' => $this->Description,
            'No'          => $this->No,
            'Period'      => $this->Period,
            'SalesUOM'    => $this->SalesUOM,
        ];
    }

    /**
     * Constructor
     *
     * @var string $BaseUOM
     * @var string $Description
     * @var string $No
     * @var \MSML\BizTalk\Type\Base\ArrayOfSalesHistoryItemPeriod $Period
     * @var string $SalesUOM
     */
    public function __construct($BaseUOM, $Description, $No, $Period, $SalesUOM)
    {
        $this->BaseUOM = $BaseUOM;
        $this->Description = $Description;
        $this->No = $No;
        $this->Period = $Period;
        $this->SalesUOM = $SalesUOM;
    }

    /**
     * @return string
     */
    public function getBaseUOM()
    {
        return $this->BaseUOM;
    }

    /**
     * @param string $BaseUOM
     * @return SalesHistoryItem
     */
    public function withBaseUOM($BaseUOM)
    {
        $new = clone $this;
        $new->BaseUOM = $BaseUOM;

        return $new;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->Description;
    }

    /**
     * @param string $Description
     * @return SalesHistoryItem
     */
    public function withDescription($Description)
    {
        $new = clone $this;
        $new->Description = $Description;

        return $new;
    }

    /**
     * @return string
     */
    public function getNo()
    {
        return $this->No;
    }

    /**
     * @param string $No
     * @return SalesHistoryItem
     */
    public function withNo($No)
    {
        $new = clone $this;
        $new->No = $No;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\ArrayOfSalesHistoryItemPeriod
     */
    public function getPeriod()
    {
        return $this->Period;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\ArrayOfSalesHistoryItemPeriod $Period
     * @return SalesHistoryItem
     */
    public function withPeriod($Period)
    {
        $new = clone $this;
        $new->Period = $Period;

        return $new;
    }

    /**
     * @return string
     */
    public function getSalesUOM()
    {
        return $this->SalesUOM;
    }

    /**
     * @param string $SalesUOM
     * @return SalesHistoryItem
     */
    public function withSalesUOM($SalesUOM)
    {
        $new = clone $this;
        $new->SalesUOM = $SalesUOM;

        return $new;
    }
}
