<?php

namespace MSML\BizTalk\Type\ShippingContact;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class RegisterShippingContact implements JsonSerializable, RequestInterface
{
    /**
     * @var string
     */
    private $email;

    /**
     * @var string
     */
    private $firstName;

    /**
     * @var string
     */
    private $language;

    /**
     * @var string
     */
    private $lastName;

    /**
     * @var string
     */
    private $navisionNumber;

    /**
     * @var string
     */
    private $salutation;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'email'          => $this->email,
            'firstName'      => $this->firstName,
            'language'       => $this->language,
            'lastName'       => $this->lastName,
            'navisionNumber' => $this->navisionNumber,
            'salutation'     => $this->salutation,
        ];
    }

    /**
     * Constructor
     *
     * @var string $email
     * @var string $firstName
     * @var string $language
     * @var string $lastName
     * @var string $navisionNumber
     * @var string $salutation
     */
    public function __construct($email, $firstName, $language, $lastName, $navisionNumber, $salutation)
    {
        $this->email = $email;
        $this->firstName = $firstName;
        $this->language = $language;
        $this->lastName = $lastName;
        $this->navisionNumber = $navisionNumber;
        $this->salutation = $salutation;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return RegisterShippingContact
     */
    public function withEmail($email)
    {
        $new = clone $this;
        $new->email = $email;

        return $new;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }

    /**
     * @param string $firstName
     * @return RegisterShippingContact
     */
    public function withFirstName($firstName)
    {
        $new = clone $this;
        $new->firstName = $firstName;

        return $new;
    }

    /**
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }

    /**
     * @param string $language
     * @return RegisterShippingContact
     */
    public function withLanguage($language)
    {
        $new = clone $this;
        $new->language = $language;

        return $new;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }

    /**
     * @param string $lastName
     * @return RegisterShippingContact
     */
    public function withLastName($lastName)
    {
        $new = clone $this;
        $new->lastName = $lastName;

        return $new;
    }

    /**
     * @return string
     */
    public function getNavisionNumber()
    {
        return $this->navisionNumber;
    }

    /**
     * @param string $navisionNumber
     * @return RegisterShippingContact
     */
    public function withNavisionNumber($navisionNumber)
    {
        $new = clone $this;
        $new->navisionNumber = $navisionNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getSalutation()
    {
        return $this->salutation;
    }

    /**
     * @param string $salutation
     * @return RegisterShippingContact
     */
    public function withSalutation($salutation)
    {
        $new = clone $this;
        $new->salutation = $salutation;

        return $new;
    }
}
