<?php

namespace MSML\BizTalk\Client\Base;

use MSML\BizTalk\Type\Base;
use Phpro\SoapClient\Type\ResultInterface;
use Phpro\SoapClient\Type\RequestInterface;
use Phpro\SoapClient\Exception\SoapException;

class BizTalkBaseClient extends \Phpro\SoapClient\Client
{
    /**
     * @param RequestInterface|Base\GetGasMeterScore $parameters
     * @return ResultInterface|Base\GetGasMeterScoreResponse
     * @throws SoapException
     */
    public function getGasMeterScore(\MSML\BizTalk\Type\Base\GetGasMeterScore $parameters) : \MSML\BizTalk\Type\Base\GetGasMeterScoreResponse
    {
        return $this->call('GetGasMeterScore', $parameters);
    }

    /**
     * @param RequestInterface|Base\VerifyLogin $parameters
     * @return ResultInterface|Base\VerifyLoginResponse
     * @throws SoapException
     */
    public function verifyLogin(\MSML\BizTalk\Type\Base\VerifyLogin $parameters) : \MSML\BizTalk\Type\Base\VerifyLoginResponse
    {
        return $this->call('VerifyLogin', $parameters);
    }

    /**
     * @param RequestInterface|Base\GetInvoiceDetails $parameters
     * @return ResultInterface|Base\GetInvoiceDetailsResponse
     * @throws SoapException
     */
    public function getInvoiceDetails(\MSML\BizTalk\Type\Base\GetInvoiceDetails $parameters) : \MSML\BizTalk\Type\Base\GetInvoiceDetailsResponse
    {
        return $this->call('GetInvoiceDetails', $parameters);
    }

    /**
     * @param RequestInterface|Base\GetOrderHistory $parameters
     * @return ResultInterface|Base\GetOrderHistoryResponse
     * @throws SoapException
     */
    public function getOrderHistory(\MSML\BizTalk\Type\Base\GetOrderHistory $parameters) : \MSML\BizTalk\Type\Base\GetOrderHistoryResponse
    {
        return $this->call('GetOrderHistory', $parameters);
    }

    /**
     * @param RequestInterface|Base\GetSalesHistory $parameters
     * @return ResultInterface|Base\GetSalesHistoryResponse
     * @throws SoapException
     */
    public function getSalesHistory(\MSML\BizTalk\Type\Base\GetSalesHistory $parameters) : \MSML\BizTalk\Type\Base\GetSalesHistoryResponse
    {
        return $this->call('GetSalesHistory', $parameters);
    }

    /**
     * @param RequestInterface|Base\GetServiceItem $parameters
     * @return ResultInterface|Base\GetServiceItemResponse
     * @throws SoapException
     */
    public function getServiceItem(\MSML\BizTalk\Type\Base\GetServiceItem $parameters) : \MSML\BizTalk\Type\Base\GetServiceItemResponse
    {
        return $this->call('GetServiceItem', $parameters);
    }

    /**
     * @param RequestInterface|Base\GetServiceContract $parameters
     * @return ResultInterface|Base\GetServiceContractResponse
     * @throws SoapException
     */
    public function getServiceContract(\MSML\BizTalk\Type\Base\GetServiceContract $parameters) : \MSML\BizTalk\Type\Base\GetServiceContractResponse
    {
        return $this->call('GetServiceContract', $parameters);
    }

    /**
     * @param RequestInterface|Base\GetPricesAndDiscounts $parameters
     * @return ResultInterface|Base\GetPricesAndDiscountsResponse
     * @throws SoapException
     */
    public function getPricesAndDiscounts(\MSML\BizTalk\Type\Base\GetPricesAndDiscounts $parameters) : \MSML\BizTalk\Type\Base\GetPricesAndDiscountsResponse
    {
        return $this->call('GetPricesAndDiscounts', $parameters);
    }

    /**
     * @param RequestInterface|Base\GetBasicData $parameters
     * @return ResultInterface|Base\GetBasicDataResponse
     * @throws SoapException
     */
    public function getBasicData(\MSML\BizTalk\Type\Base\GetBasicData $parameters) : \MSML\BizTalk\Type\Base\GetBasicDataResponse
    {
        return $this->call('GetBasicData', $parameters);
    }

    /**
     * @param RequestInterface|Base\GetCustomerLedgerEntry $parameters
     * @return ResultInterface|Base\GetCustomerLedgerEntryResponse
     * @throws SoapException
     */
    public function getCustomerLedgerEntry(\MSML\BizTalk\Type\Base\GetCustomerLedgerEntry $parameters) : \MSML\BizTalk\Type\Base\GetCustomerLedgerEntryResponse
    {
        return $this->call('GetCustomerLedgerEntry', $parameters);
    }

    /**
     * @param RequestInterface|Base\ResetPassword $parameters
     * @return ResultInterface|Base\ResetPasswordResponse
     * @throws SoapException
     */
    public function resetPassword(\MSML\BizTalk\Type\Base\ResetPassword $parameters) : \MSML\BizTalk\Type\Base\ResetPasswordResponse
    {
        return $this->call('ResetPassword', $parameters);
    }

    /**
     * @param RequestInterface|Base\ActivateUser $parameters
     * @return ResultInterface|Base\ActivateUserResponse
     * @throws SoapException
     */
    public function activateUser(\MSML\BizTalk\Type\Base\ActivateUser $parameters) : \MSML\BizTalk\Type\Base\ActivateUserResponse
    {
        return $this->call('ActivateUser', $parameters);
    }

    /**
     * @param RequestInterface|Base\RegisterUser $parameters
     * @return ResultInterface|Base\RegisterUserResponse
     * @throws SoapException
     */
    public function registerUser(\MSML\BizTalk\Type\Base\RegisterUser $parameters) : \MSML\BizTalk\Type\Base\RegisterUserResponse
    {
        return $this->call('RegisterUser', $parameters);
    }

    /**
     * @param RequestInterface|Base\GetDocument $parameters
     * @return ResultInterface|Base\GetDocumentResponse
     * @throws SoapException
     */
    public function getDocument(\MSML\BizTalk\Type\Base\GetDocument $parameters) : \MSML\BizTalk\Type\Base\GetDocumentResponse
    {
        return $this->call('GetDocument', $parameters);
    }

    /**
     * @param RequestInterface|Base\GetCustomerInfo $parameters
     * @return ResultInterface|Base\GetCustomerInfoResponse
     * @throws SoapException
     */
    public function getCustomerInfo(\MSML\BizTalk\Type\Base\GetCustomerInfo $parameters) : \MSML\BizTalk\Type\Base\GetCustomerInfoResponse
    {
        return $this->call('GetCustomerInfo', $parameters);
    }

    /**
     * @param RequestInterface|Base\GetFuelTank $parameters
     * @return ResultInterface|Base\GetFuelTankResponse
     * @throws SoapException
     */
    public function getFuelTank(\MSML\BizTalk\Type\Base\GetFuelTank $parameters) : \MSML\BizTalk\Type\Base\GetFuelTankResponse
    {
        return $this->call('GetFuelTank', $parameters);
    }

    /**
     * @param RequestInterface|Base\GetContact $parameters
     * @return ResultInterface|Base\GetContactResponse
     * @throws SoapException
     */
    public function getContact(\MSML\BizTalk\Type\Base\GetContact $parameters) : \MSML\BizTalk\Type\Base\GetContactResponse
    {
        return $this->call('GetContact', $parameters);
    }

    /**
     * @param RequestInterface|Base\GeMaterialItem $parameters
     * @return ResultInterface|Base\GeMaterialItemResponse
     * @throws SoapException
     */
    public function geMaterialItem(\MSML\BizTalk\Type\Base\GeMaterialItem $parameters) : \MSML\BizTalk\Type\Base\GeMaterialItemResponse
    {
        return $this->call('GeMaterialItem', $parameters);
    }

    /**
     * @param RequestInterface|Base\GetTelemetryHistory $parameters
     * @return ResultInterface|Base\GetTelemetryHistoryResponse
     * @throws SoapException
     */
    public function getTelemetryHistory(\MSML\BizTalk\Type\Base\GetTelemetryHistory $parameters) : \MSML\BizTalk\Type\Base\GetTelemetryHistoryResponse
    {
        return $this->call('GetTelemetryHistory', $parameters);
    }
}
