<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class ArrayOfInvoiceLine implements JsonSerializable, RequestInterface
{
    /**
     * @var \MSML\BizTalk\Type\Base\InvoiceLine
     */
    private $InvoiceLine;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'InvoiceLine' => $this->InvoiceLine,
        ];
    }

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Type\Base\InvoiceLine $InvoiceLine
     */
    public function __construct($InvoiceLine)
    {
        $this->InvoiceLine = $InvoiceLine;
    }

    /**
     * @return \MSML\BizTalk\Type\Base\InvoiceLine
     */
    public function getInvoiceLine()
    {
        return $this->InvoiceLine;
    }

    /**
     * @param \MSML\BizTalk\Type\Base\InvoiceLine $InvoiceLine
     * @return ArrayOfInvoiceLine
     */
    public function withInvoiceLine($InvoiceLine)
    {
        $new = clone $this;
        $new->InvoiceLine = $InvoiceLine;

        return $new;
    }
}
