<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class ContactResult implements JsonSerializable, RequestInterface
{
    /**
     * @var \DateTime
     */
    private $BirthDate;

    /**
     * @var string
     */
    private $ContactId;

    /**
     * @var string
     */
    private $ContactPersonStatus;

    /**
     * @var bool
     */
    private $DoNotCall;

    /**
     * @var string
     */
    private $Email;

    /**
     * @var string
     */
    private $ErrorMesage;

    /**
     * @var string
     */
    private $FirstName;

    /**
     * @var bool
     */
    private $HasOptedOutOfEmail;

    /**
     * @var string
     */
    private $Language;

    /**
     * @var string
     */
    private $LastName;

    /**
     * @var string
     */
    private $MobilePhone;

    /**
     * @var string
     */
    private $MyPrimagazAccountStatus;

    /**
     * @var string
     */
    private $NavisionNumber;

    /**
     * @var string
     */
    private $Phone;

    /**
     * @var string
     */
    private $Salutation;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'BirthDate'               => $this->BirthDate,
            'ContactId'               => $this->ContactId,
            'ContactPersonStatus'     => $this->ContactPersonStatus,
            'DoNotCall'               => $this->DoNotCall,
            'Email'                   => $this->Email,
            'ErrorMesage'             => $this->ErrorMesage,
            'FirstName'               => $this->FirstName,
            'HasOptedOutOfEmail'      => $this->HasOptedOutOfEmail,
            'Language'                => $this->Language,
            'LastName'                => $this->LastName,
            'MobilePhone'             => $this->MobilePhone,
            'MyPrimagazAccountStatus' => $this->MyPrimagazAccountStatus,
            'NavisionNumber'          => $this->NavisionNumber,
            'Phone'                   => $this->Phone,
            'Salutation'              => $this->Salutation,
        ];
    }

    /**
     * Constructor
     *
     * @var \DateTime $BirthDate
     * @var string $ContactId
     * @var string $ContactPersonStatus
     * @var bool $DoNotCall
     * @var string $Email
     * @var string $ErrorMesage
     * @var string $FirstName
     * @var bool $HasOptedOutOfEmail
     * @var string $Language
     * @var string $LastName
     * @var string $MobilePhone
     * @var string $MyPrimagazAccountStatus
     * @var string $NavisionNumber
     * @var string $Phone
     * @var string $Salutation
     */
    public function __construct($BirthDate, $ContactId, $ContactPersonStatus, $DoNotCall, $Email, $ErrorMesage, $FirstName, $HasOptedOutOfEmail, $Language, $LastName, $MobilePhone, $MyPrimagazAccountStatus, $NavisionNumber, $Phone, $Salutation)
    {
        $this->BirthDate = $BirthDate;
        $this->ContactId = $ContactId;
        $this->ContactPersonStatus = $ContactPersonStatus;
        $this->DoNotCall = $DoNotCall;
        $this->Email = $Email;
        $this->ErrorMesage = $ErrorMesage;
        $this->FirstName = $FirstName;
        $this->HasOptedOutOfEmail = $HasOptedOutOfEmail;
        $this->Language = $Language;
        $this->LastName = $LastName;
        $this->MobilePhone = $MobilePhone;
        $this->MyPrimagazAccountStatus = $MyPrimagazAccountStatus;
        $this->NavisionNumber = $NavisionNumber;
        $this->Phone = $Phone;
        $this->Salutation = $Salutation;
    }

    /**
     * @return \DateTime
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }

    /**
     * @param \DateTime $BirthDate
     * @return ContactResult
     */
    public function withBirthDate($BirthDate)
    {
        $new = clone $this;
        $new->BirthDate = $BirthDate;

        return $new;
    }

    /**
     * @return string
     */
    public function getContactId()
    {
        return $this->ContactId;
    }

    /**
     * @param string $ContactId
     * @return ContactResult
     */
    public function withContactId($ContactId)
    {
        $new = clone $this;
        $new->ContactId = $ContactId;

        return $new;
    }

    /**
     * @return string
     */
    public function getContactPersonStatus()
    {
        return $this->ContactPersonStatus;
    }

    /**
     * @param string $ContactPersonStatus
     * @return ContactResult
     */
    public function withContactPersonStatus($ContactPersonStatus)
    {
        $new = clone $this;
        $new->ContactPersonStatus = $ContactPersonStatus;

        return $new;
    }

    /**
     * @return bool
     */
    public function getDoNotCall()
    {
        return $this->DoNotCall;
    }

    /**
     * @param bool $DoNotCall
     * @return ContactResult
     */
    public function withDoNotCall($DoNotCall)
    {
        $new = clone $this;
        $new->DoNotCall = $DoNotCall;

        return $new;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->Email;
    }

    /**
     * @param string $Email
     * @return ContactResult
     */
    public function withEmail($Email)
    {
        $new = clone $this;
        $new->Email = $Email;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMesage()
    {
        return $this->ErrorMesage;
    }

    /**
     * @param string $ErrorMesage
     * @return ContactResult
     */
    public function withErrorMesage($ErrorMesage)
    {
        $new = clone $this;
        $new->ErrorMesage = $ErrorMesage;

        return $new;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }

    /**
     * @param string $FirstName
     * @return ContactResult
     */
    public function withFirstName($FirstName)
    {
        $new = clone $this;
        $new->FirstName = $FirstName;

        return $new;
    }

    /**
     * @return bool
     */
    public function getHasOptedOutOfEmail()
    {
        return $this->HasOptedOutOfEmail;
    }

    /**
     * @param bool $HasOptedOutOfEmail
     * @return ContactResult
     */
    public function withHasOptedOutOfEmail($HasOptedOutOfEmail)
    {
        $new = clone $this;
        $new->HasOptedOutOfEmail = $HasOptedOutOfEmail;

        return $new;
    }

    /**
     * @return string
     */
    public function getLanguage()
    {
        return $this->Language;
    }

    /**
     * @param string $Language
     * @return ContactResult
     */
    public function withLanguage($Language)
    {
        $new = clone $this;
        $new->Language = $Language;

        return $new;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->LastName;
    }

    /**
     * @param string $LastName
     * @return ContactResult
     */
    public function withLastName($LastName)
    {
        $new = clone $this;
        $new->LastName = $LastName;

        return $new;
    }

    /**
     * @return string
     */
    public function getMobilePhone()
    {
        return $this->MobilePhone;
    }

    /**
     * @param string $MobilePhone
     * @return ContactResult
     */
    public function withMobilePhone($MobilePhone)
    {
        $new = clone $this;
        $new->MobilePhone = $MobilePhone;

        return $new;
    }

    /**
     * @return string
     */
    public function getMyPrimagazAccountStatus()
    {
        return $this->MyPrimagazAccountStatus;
    }

    /**
     * @param string $MyPrimagazAccountStatus
     * @return ContactResult
     */
    public function withMyPrimagazAccountStatus($MyPrimagazAccountStatus)
    {
        $new = clone $this;
        $new->MyPrimagazAccountStatus = $MyPrimagazAccountStatus;

        return $new;
    }

    /**
     * @return string
     */
    public function getNavisionNumber()
    {
        return $this->NavisionNumber;
    }

    /**
     * @param string $NavisionNumber
     * @return ContactResult
     */
    public function withNavisionNumber($NavisionNumber)
    {
        $new = clone $this;
        $new->NavisionNumber = $NavisionNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getPhone()
    {
        return $this->Phone;
    }

    /**
     * @param string $Phone
     * @return ContactResult
     */
    public function withPhone($Phone)
    {
        $new = clone $this;
        $new->Phone = $Phone;

        return $new;
    }

    /**
     * @return string
     */
    public function getSalutation()
    {
        return $this->Salutation;
    }

    /**
     * @param string $Salutation
     * @return ContactResult
     */
    public function withSalutation($Salutation)
    {
        $new = clone $this;
        $new->Salutation = $Salutation;

        return $new;
    }
}
