<?php

namespace MSML\BizTalk\Type\Base;

use JsonSerializable;
use Phpro\SoapClient\Type\RequestInterface;

class GasMeterInfo implements JsonSerializable, RequestInterface
{
    /**
     * @var bool
     */
    private $Correction;

    /**
     * @var float
     */
    private $Difference;

    /**
     * @var \DateTime
     */
    private $EndDate;

    /**
     * @var float
     */
    private $EndScore;

    /**
     * @var string
     */
    private $GasmeterNo;

    /**
     * @var string
     */
    private $RecordingType;

    /**
     * @var string
     */
    private $ServiceItemNo;

    /**
     * @var \DateTime
     */
    private $StartDate;

    /**
     * @var float
     */
    private $StartScore;

    /**
     * @var string
     */
    private $Type;

    /**
     * @var boolean
     */
    private $Expected;

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'Correction'    => $this->Correction,
            'Difference'    => $this->Difference,
            'EndDate'       => $this->EndDate,
            'EndScore'      => $this->EndScore,
            'GasmeterNo'    => $this->GasmeterNo,
            'RecordingType' => $this->RecordingType,
            'ServiceItemNo' => $this->ServiceItemNo,
            'StartDate'     => $this->StartDate,
            'StartScore'    => $this->StartScore,
            'Type'          => $this->Type,
            'Expected'      => $this->Expected,
        ];
    }

    /**
     * Constructor
     *
     * @var bool $Correction
     * @var float $Difference
     * @var \DateTime $EndDate
     * @var float $EndScore
     * @var string $GasmeterNo
     * @var string $RecordingType
     * @var string $ServiceItemNo
     * @var \DateTime $StartDate
     * @var float $StartScore
     * @var string $Type
     * @var boolean $Expected
     */
    public function __construct($Correction, $Difference, $EndDate, $EndScore, $GasmeterNo, $RecordingType, $ServiceItemNo, $StartDate, $StartScore, $Type, $Expected)
    {
        $this->Correction = $Correction;
        $this->Difference = $Difference;
        $this->EndDate = $EndDate;
        $this->EndScore = $EndScore;
        $this->GasmeterNo = $GasmeterNo;
        $this->RecordingType = $RecordingType;
        $this->ServiceItemNo = $ServiceItemNo;
        $this->StartDate = $StartDate;
        $this->StartScore = $StartScore;
        $this->Type = $Type;
        $this->Expected = $Expected;
    }

    /**
     * @return bool
     */
    public function getCorrection()
    {
        return $this->Correction;
    }

    /**
     * @param bool $Correction
     * @return GasMeterInfo
     */
    public function withCorrection($Correction)
    {
        $new = clone $this;
        $new->Correction = $Correction;

        return $new;
    }

    /**
     * @return float
     */
    public function getDifference()
    {
        return $this->Difference;
    }

    /**
     * @param float $Difference
     * @return GasMeterInfo
     */
    public function withDifference($Difference)
    {
        $new = clone $this;
        $new->Difference = $Difference;

        return $new;
    }

    /**
     * @return \DateTime
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }

    /**
     * @param \DateTime $EndDate
     * @return GasMeterInfo
     */
    public function withEndDate($EndDate)
    {
        $new = clone $this;
        $new->EndDate = $EndDate;

        return $new;
    }

    /**
     * @return float
     */
    public function getEndScore()
    {
        return $this->EndScore;
    }

    /**
     * @param float $EndScore
     * @return GasMeterInfo
     */
    public function withEndScore($EndScore)
    {
        $new = clone $this;
        $new->EndScore = $EndScore;

        return $new;
    }

    /**
     * @return string
     */
    public function getGasmeterNo()
    {
        return $this->GasmeterNo;
    }

    /**
     * @param string $GasmeterNo
     * @return GasMeterInfo
     */
    public function withGasmeterNo($GasmeterNo)
    {
        $new = clone $this;
        $new->GasmeterNo = $GasmeterNo;

        return $new;
    }

    /**
     * @return string
     */
    public function getRecordingType()
    {
        return $this->RecordingType;
    }

    /**
     * @param string $RecordingType
     * @return GasMeterInfo
     */
    public function withRecordingType($RecordingType)
    {
        $new = clone $this;
        $new->RecordingType = $RecordingType;

        return $new;
    }

    /**
     * @return string
     */
    public function getServiceItemNo()
    {
        return $this->ServiceItemNo;
    }

    /**
     * @param string $ServiceItemNo
     * @return GasMeterInfo
     */
    public function withServiceItemNo($ServiceItemNo)
    {
        $new = clone $this;
        $new->ServiceItemNo = $ServiceItemNo;

        return $new;
    }

    /**
     * @return \DateTime
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }

    /**
     * @param \DateTime $StartDate
     * @return GasMeterInfo
     */
    public function withStartDate($StartDate)
    {
        $new = clone $this;
        $new->StartDate = $StartDate;

        return $new;
    }

    /**
     * @return float
     */
    public function getStartScore()
    {
        return $this->StartScore;
    }

    /**
     * @param float $StartScore
     * @return GasMeterInfo
     */
    public function withStartScore($StartScore)
    {
        $new = clone $this;
        $new->StartScore = $StartScore;

        return $new;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }

    /**
     * @param string $Type
     * @return GasMeterInfo
     */
    public function withType($Type)
    {
        $new = clone $this;
        $new->Type = $Type;

        return $new;
    }

    /**
     * @return boolean
     */
    public function getExpected()
    {
        return $this->Expected;
    }

    /**
     * @param string $Expected
     * @return GasMeterInfo
     */
    public function withExpected($Expected)
    {
        $new = clone $this;
        $new->Expected = $Expected;

        return $new;
    }
}
