<?php

use Soap\ExtSoapEngine\ExtSoapOptions;
use Phpro\SoapClient\CodeGenerator\Rules;
use Phpro\SoapClient\CodeGenerator\Assembler;
use Phpro\SoapClient\Soap\DefaultEngineFactory;
use Phpro\SoapClient\CodeGenerator\Config\Config;

return Config::create()
    ->setEngine($engine = DefaultEngineFactory::create(
        ExtSoapOptions::defaults(config('biztalk.url') . config('biztalk.endpoint.bottle_order'), [])
            ->disableWsdlCache()
    ))
    ->setTypeDestination('src/BottleOrder/Type')
    ->setTypeNamespace('MSML\BizTalk\BottleOrder\Type')
    ->setClientDestination('src/BottleOrder')
    ->setClientName('BottleOrderClient')
    ->setClientNamespace('MSML\BizTalk\BottleOrder')
    ->setClassMapDestination('src/BottleOrder')
    ->setClassMapName('BottleOrderClassmap')
    ->setClassMapNamespace('MSML\BizTalk\BottleOrder')
    ->addRule(new Rules\AssembleRule(new Assembler\GetterAssembler(new Assembler\GetterAssemblerOptions())))
    ->addRule(new Rules\AssembleRule(new Assembler\ImmutableSetterAssembler(
        new Assembler\ImmutableSetterAssemblerOptions()
    )))
    ->addRule(
        new Rules\IsRequestRule(
            $engine->getMetadata(),
            new Rules\MultiRule([
                new Rules\AssembleRule(new Assembler\RequestAssembler()),
                new Rules\AssembleRule(new Assembler\ConstructorAssembler(new Assembler\ConstructorAssemblerOptions())),
            ])
        )
    )
    ->addRule(
        new Rules\IsResultRule(
            $engine->getMetadata(),
            new Rules\MultiRule([
                new Rules\AssembleRule(new Assembler\ResultAssembler()),
            ])
        )
    );
