<?php

use Soap\ExtSoapEngine\ExtSoapOptions;
use Phpro\SoapClient\CodeGenerator\Rules;
use Phpro\SoapClient\CodeGenerator\Assembler;
use Phpro\SoapClient\Soap\DefaultEngineFactory;
use Phpro\SoapClient\CodeGenerator\Config\Config;

return Config::create()
    ->setEngine($engine = DefaultEngineFactory::create(
        ExtSoapOptions::defaults(config('biztalk.url') . config('biztalk.endpoint.contact'), [])
            ->disableWsdlCache()
    ))
    ->setTypeDestination('src/Contact/Type')
    ->setTypeNamespace('MSML\BizTalk\Contact\Type')
    ->setClientDestination('src/Contact')
    ->setClientName('ContactClient')
    ->setClientNamespace('MSML\BizTalk\Contact')
    ->setClassMapDestination('src/Contact')
    ->setClassMapName('ContactClassmap')
    ->setClassMapNamespace('MSML\BizTalk\Contact')
    ->addRule(new Rules\AssembleRule(new Assembler\GetterAssembler(new Assembler\GetterAssemblerOptions())))
    ->addRule(new Rules\AssembleRule(new Assembler\ImmutableSetterAssembler(
        new Assembler\ImmutableSetterAssemblerOptions()
    )))
    ->addRule(
        new Rules\IsRequestRule(
            $engine->getMetadata(),
            new Rules\MultiRule([
                new Rules\AssembleRule(new Assembler\RequestAssembler()),
                new Rules\AssembleRule(new Assembler\ConstructorAssembler(new Assembler\ConstructorAssemblerOptions())),
            ])
        )
    )
    ->addRule(
        new Rules\IsResultRule(
            $engine->getMetadata(),
            new Rules\MultiRule([
                new Rules\AssembleRule(new Assembler\ResultAssembler()),
            ])
        )
    );
