<?php

use Soap\ExtSoapEngine\ExtSoapOptions;
use Phpro\SoapClient\CodeGenerator\Rules;
use Phpro\SoapClient\CodeGenerator\Assembler;
use Phpro\SoapClient\Soap\DefaultEngineFactory;
use Phpro\SoapClient\CodeGenerator\Config\Config;

return Config::create()
    ->setEngine($engine = DefaultEngineFactory::create(
        ExtSoapOptions::defaults(config('biztalk.url') . config('biztalk.endpoint.gas_meter_score'), [])
            ->disableWsdlCache()
    ))
    ->setTypeDestination('src/GasMeterScore/Type')
    ->setTypeNamespace('MSML\BizTalk\GasMeterScore\Type')
    ->setClientDestination('src/GasMeterScore')
    ->setClientName('GasMeterScoreClient')
    ->setClientNamespace('MSML\BizTalk\GasMeterScore')
    ->setClassMapDestination('src/GasMeterScore')
    ->setClassMapName('GasMeterScoreClassmap')
    ->setClassMapNamespace('MSML\BizTalk\GasMeterScore')
    ->addRule(new Rules\AssembleRule(new Assembler\GetterAssembler(new Assembler\GetterAssemblerOptions())))
    ->addRule(new Rules\AssembleRule(new Assembler\ImmutableSetterAssembler(
        new Assembler\ImmutableSetterAssemblerOptions()
    )))
    ->addRule(
        new Rules\IsRequestRule(
            $engine->getMetadata(),
            new Rules\MultiRule([
                new Rules\AssembleRule(new Assembler\RequestAssembler()),
                new Rules\AssembleRule(new Assembler\ConstructorAssembler(new Assembler\ConstructorAssemblerOptions())),
            ])
        )
    )
    ->addRule(
        new Rules\IsResultRule(
            $engine->getMetadata(),
            new Rules\MultiRule([
                new Rules\AssembleRule(new Assembler\ResultAssembler()),
            ])
        )
    );
