<?php

use Soap\ExtSoapEngine\ExtSoapOptions;
use Phpro\SoapClient\CodeGenerator\Rules;
use Phpro\SoapClient\CodeGenerator\Assembler;
use Phpro\SoapClient\Soap\DefaultEngineFactory;
use Phpro\SoapClient\CodeGenerator\Config\Config;

return Config::create()
    ->setEngine($engine = DefaultEngineFactory::create(
        ExtSoapOptions::defaults(config('biztalk.url') . config('biztalk.endpoint.primary_contact'), [])
            ->disableWsdlCache()
    ))
    ->setTypeDestination('src/PrimaryContact/Type')
    ->setTypeNamespace('MSML\BizTalk\PrimaryContact\Type')
    ->setClientDestination('src/PrimaryContact')
    ->setClientName('PrimaryContactClient')
    ->setClientNamespace('MSML\BizTalk\PrimaryContact')
    ->setClassMapDestination('src/PrimaryContact')
    ->setClassMapName('PrimaryContactClassmap')
    ->setClassMapNamespace('MSML\BizTalk\PrimaryContact')
    ->addRule(new Rules\AssembleRule(new Assembler\GetterAssembler(new Assembler\GetterAssemblerOptions())))
    ->addRule(new Rules\AssembleRule(new Assembler\ImmutableSetterAssembler(
        new Assembler\ImmutableSetterAssemblerOptions()
    )))
    ->addRule(
        new Rules\IsRequestRule(
            $engine->getMetadata(),
            new Rules\MultiRule([
                new Rules\AssembleRule(new Assembler\RequestAssembler()),
                new Rules\AssembleRule(new Assembler\ConstructorAssembler(new Assembler\ConstructorAssemblerOptions())),
            ])
        )
    )
    ->addRule(
        new Rules\IsResultRule(
            $engine->getMetadata(),
            new Rules\MultiRule([
                new Rules\AssembleRule(new Assembler\ResultAssembler()),
            ])
        )
    );
