<?php

use Soap\ExtSoapEngine\ExtSoapOptions;
use Phpro\SoapClient\CodeGenerator\Rules;
use Phpro\SoapClient\CodeGenerator\Assembler;
use Phpro\SoapClient\Soap\DefaultEngineFactory;
use Phpro\SoapClient\CodeGenerator\Config\Config;

return Config::create()
    ->setEngine($engine = DefaultEngineFactory::create(
        ExtSoapOptions::defaults(config('biztalk.url') . config('biztalk.endpoint.shipping_contact'), [])
            ->disableWsdlCache()
    ))
    ->setTypeDestination('src/ShippingContact/Type')
    ->setTypeNamespace('MSML\BizTalk\ShippingContact\Type')
    ->setClientDestination('src/ShippingContact')
    ->setClientName('ShippingContactClient')
    ->setClientNamespace('MSML\BizTalk\ShippingContact')
    ->setClassMapDestination('src/ShippingContact')
    ->setClassMapName('ShippingContactClassmap')
    ->setClassMapNamespace('MSML\BizTalk\ShippingContact')
    ->addRule(new Rules\AssembleRule(new Assembler\GetterAssembler(new Assembler\GetterAssemblerOptions())))
    ->addRule(new Rules\AssembleRule(new Assembler\ImmutableSetterAssembler(
        new Assembler\ImmutableSetterAssemblerOptions()
    )))
    ->addRule(
        new Rules\IsRequestRule(
            $engine->getMetadata(),
            new Rules\MultiRule([
                new Rules\AssembleRule(new Assembler\RequestAssembler()),
                new Rules\AssembleRule(new Assembler\ConstructorAssembler(new Assembler\ConstructorAssemblerOptions())),
            ])
        )
    )
    ->addRule(
        new Rules\IsResultRule(
            $engine->getMetadata(),
            new Rules\MultiRule([
                new Rules\AssembleRule(new Assembler\ResultAssembler()),
            ])
        )
    );
