<?php

namespace MSML\BizTalk\Base;

use Phpro\SoapClient\Caller\Caller;
use Phpro\SoapClient\Type\ResultInterface;
use Phpro\SoapClient\Type\RequestInterface;
use Phpro\SoapClient\Exception\SoapException;

class BaseClient
{
    /**
     * @var Caller
     */
    private $caller;

    public function __construct(\Phpro\SoapClient\Caller\Caller $caller)
    {
        $this->caller = $caller;
    }

    /**
     * @param RequestInterface|Type\GetGasMeterScore $parameters
     * @return ResultInterface|Type\GetGasMeterScoreResponse
     * @throws SoapException
     */
    public function getGasMeterScore(\MSML\BizTalk\Base\Type\GetGasMeterScore $parameters) : \MSML\BizTalk\Base\Type\GetGasMeterScoreResponse
    {
        return ($this->caller)('GetGasMeterScore', $parameters);
    }

    /**
     * @param RequestInterface|Type\VerifyLogin $parameters
     * @return ResultInterface|Type\VerifyLoginResponse
     * @throws SoapException
     */
    public function verifyLogin(\MSML\BizTalk\Base\Type\VerifyLogin $parameters) : \MSML\BizTalk\Base\Type\VerifyLoginResponse
    {
        return ($this->caller)('VerifyLogin', $parameters);
    }

    /**
     * @param RequestInterface|Type\GetInvoiceDetails $parameters
     * @return ResultInterface|Type\GetInvoiceDetailsResponse
     * @throws SoapException
     */
    public function getInvoiceDetails(\MSML\BizTalk\Base\Type\GetInvoiceDetails $parameters) : \MSML\BizTalk\Base\Type\GetInvoiceDetailsResponse
    {
        return ($this->caller)('GetInvoiceDetails', $parameters);
    }

    /**
     * @param RequestInterface|Type\GetOrderHistory $parameters
     * @return ResultInterface|Type\GetOrderHistoryResponse
     * @throws SoapException
     */
    public function getOrderHistory(\MSML\BizTalk\Base\Type\GetOrderHistory $parameters) : \MSML\BizTalk\Base\Type\GetOrderHistoryResponse
    {
        return ($this->caller)('GetOrderHistory', $parameters);
    }

    /**
     * @param RequestInterface|Type\GetSalesHistory $parameters
     * @return ResultInterface|Type\GetSalesHistoryResponse
     * @throws SoapException
     */
    public function getSalesHistory(\MSML\BizTalk\Base\Type\GetSalesHistory $parameters) : \MSML\BizTalk\Base\Type\GetSalesHistoryResponse
    {
        return ($this->caller)('GetSalesHistory', $parameters);
    }

    /**
     * @param RequestInterface|Type\GetServiceItem $parameters
     * @return ResultInterface|Type\GetServiceItemResponse
     * @throws SoapException
     */
    public function getServiceItem(\MSML\BizTalk\Base\Type\GetServiceItem $parameters) : \MSML\BizTalk\Base\Type\GetServiceItemResponse
    {
        return ($this->caller)('GetServiceItem', $parameters);
    }

    /**
     * @param RequestInterface|Type\GetServiceContract $parameters
     * @return ResultInterface|Type\GetServiceContractResponse
     * @throws SoapException
     */
    public function getServiceContract(\MSML\BizTalk\Base\Type\GetServiceContract $parameters) : \MSML\BizTalk\Base\Type\GetServiceContractResponse
    {
        return ($this->caller)('GetServiceContract', $parameters);
    }

    /**
     * @param RequestInterface|Type\GetPricesAndDiscounts $parameters
     * @return ResultInterface|Type\GetPricesAndDiscountsResponse
     * @throws SoapException
     */
    public function getPricesAndDiscounts(\MSML\BizTalk\Base\Type\GetPricesAndDiscounts $parameters) : \MSML\BizTalk\Base\Type\GetPricesAndDiscountsResponse
    {
        return ($this->caller)('GetPricesAndDiscounts', $parameters);
    }

    /**
     * @param RequestInterface|Type\GetBasicData $parameters
     * @return ResultInterface|Type\GetBasicDataResponse
     * @throws SoapException
     */
    public function getBasicData(\MSML\BizTalk\Base\Type\GetBasicData $parameters) : \MSML\BizTalk\Base\Type\GetBasicDataResponse
    {
        return ($this->caller)('GetBasicData', $parameters);
    }

    /**
     * @param RequestInterface|Type\GetCustomerLedgerEntry $parameters
     * @return ResultInterface|Type\GetCustomerLedgerEntryResponse
     * @throws SoapException
     */
    public function getCustomerLedgerEntry(\MSML\BizTalk\Base\Type\GetCustomerLedgerEntry $parameters) : \MSML\BizTalk\Base\Type\GetCustomerLedgerEntryResponse
    {
        return ($this->caller)('GetCustomerLedgerEntry', $parameters);
    }

    /**
     * @param RequestInterface|Type\ResetPassword $parameters
     * @return ResultInterface|Type\ResetPasswordResponse
     * @throws SoapException
     */
    public function resetPassword(\MSML\BizTalk\Base\Type\ResetPassword $parameters) : \MSML\BizTalk\Base\Type\ResetPasswordResponse
    {
        return ($this->caller)('ResetPassword', $parameters);
    }

    /**
     * @param RequestInterface|Type\ActivateUser $parameters
     * @return ResultInterface|Type\ActivateUserResponse
     * @throws SoapException
     */
    public function activateUser(\MSML\BizTalk\Base\Type\ActivateUser $parameters) : \MSML\BizTalk\Base\Type\ActivateUserResponse
    {
        return ($this->caller)('ActivateUser', $parameters);
    }

    /**
     * @param RequestInterface|Type\RegisterUser $parameters
     * @return ResultInterface|Type\RegisterUserResponse
     * @throws SoapException
     */
    public function registerUser(\MSML\BizTalk\Base\Type\RegisterUser $parameters) : \MSML\BizTalk\Base\Type\RegisterUserResponse
    {
        return ($this->caller)('RegisterUser', $parameters);
    }

    /**
     * @param RequestInterface|Type\GetDocument $parameters
     * @return ResultInterface|Type\GetDocumentResponse
     * @throws SoapException
     */
    public function getDocument(\MSML\BizTalk\Base\Type\GetDocument $parameters) : \MSML\BizTalk\Base\Type\GetDocumentResponse
    {
        return ($this->caller)('GetDocument', $parameters);
    }

    /**
     * @param RequestInterface|Type\GetCustomerInfo $parameters
     * @return ResultInterface|Type\GetCustomerInfoResponse
     * @throws SoapException
     */
    public function getCustomerInfo(\MSML\BizTalk\Base\Type\GetCustomerInfo $parameters) : \MSML\BizTalk\Base\Type\GetCustomerInfoResponse
    {
        return ($this->caller)('GetCustomerInfo', $parameters);
    }

    /**
     * @param RequestInterface|Type\GetFuelTank $parameters
     * @return ResultInterface|Type\GetFuelTankResponse
     * @throws SoapException
     */
    public function getFuelTank(\MSML\BizTalk\Base\Type\GetFuelTank $parameters) : \MSML\BizTalk\Base\Type\GetFuelTankResponse
    {
        return ($this->caller)('GetFuelTank', $parameters);
    }

    /**
     * @param RequestInterface|Type\GetContact $parameters
     * @return ResultInterface|Type\GetContactResponse
     * @throws SoapException
     */
    public function getContact(\MSML\BizTalk\Base\Type\GetContact $parameters) : \MSML\BizTalk\Base\Type\GetContactResponse
    {
        return ($this->caller)('GetContact', $parameters);
    }

    /**
     * @param RequestInterface|Type\GeMaterialItem $parameters
     * @return ResultInterface|Type\GeMaterialItemResponse
     * @throws SoapException
     */
    public function geMaterialItem(\MSML\BizTalk\Base\Type\GeMaterialItem $parameters) : \MSML\BizTalk\Base\Type\GeMaterialItemResponse
    {
        return ($this->caller)('GeMaterialItem', $parameters);
    }

    /**
     * @param RequestInterface|Type\GetTelemetryHistory $parameters
     * @return ResultInterface|Type\GetTelemetryHistoryResponse
     * @throws SoapException
     */
    public function getTelemetryHistory(\MSML\BizTalk\Base\Type\GetTelemetryHistory $parameters) : \MSML\BizTalk\Base\Type\GetTelemetryHistoryResponse
    {
        return ($this->caller)('GetTelemetryHistory', $parameters);
    }
}
