<?php

namespace MSML\BizTalk\Base;

use Soap\ExtSoapEngine\ExtSoapOptions;
use Phpro\SoapClient\Caller\EngineCaller;
use Phpro\SoapClient\Soap\DefaultEngineFactory;
use Phpro\SoapClient\Caller\EventDispatchingCaller;
use Symfony\Component\EventDispatcher\EventDispatcher;

class BaseClientFactory
{
    public static function factory(string $wsdl) : \MSML\BizTalk\Base\BaseClient
    {
        $engine = DefaultEngineFactory::create(
            ExtSoapOptions::defaults($wsdl, [])
                ->withClassMap(BaseClassmap::getCollection())
        );

        $eventDispatcher = new EventDispatcher();
        $caller = new EventDispatchingCaller(new EngineCaller($engine), $eventDispatcher);

        return new BaseClient($caller);
    }
}
