<?php

namespace MSML\BizTalk\Base\Type;

class Account
{
    /**
     * @var string
     */
    private $ABcode;

    /**
     * @var string
     */
    private $CUNumber;

    /**
     * @var string
     */
    private $DeliveryCustomerNumber;

    /**
     * @return string
     */
    public function getABcode()
    {
        return $this->ABcode;
    }

    /**
     * @param string $ABcode
     * @return Account
     */
    public function withABcode($ABcode)
    {
        $new = clone $this;
        $new->ABcode = $ABcode;

        return $new;
    }

    /**
     * @return string
     */
    public function getCUNumber()
    {
        return $this->CUNumber;
    }

    /**
     * @param string $CUNumber
     * @return Account
     */
    public function withCUNumber($CUNumber)
    {
        $new = clone $this;
        $new->CUNumber = $CUNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getDeliveryCustomerNumber()
    {
        return $this->DeliveryCustomerNumber;
    }

    /**
     * @param string $DeliveryCustomerNumber
     * @return Account
     */
    public function withDeliveryCustomerNumber($DeliveryCustomerNumber)
    {
        $new = clone $this;
        $new->DeliveryCustomerNumber = $DeliveryCustomerNumber;

        return $new;
    }
}
