<?php

namespace MSML\BizTalk\Base\Type;

class BaseDataResult
{
    /**
     * @var string
     */
    private $ABCode;

    /**
     * @var string
     */
    private $Application;

    /**
     * @var string
     */
    private $City;

    /**
     * @var string
     */
    private $Country;

    /**
     * @var string
     */
    private $CustomerName;

    /**
     * @var string
     */
    private $CustomerNumber;

    /**
     * @var \DateTimeInterface
     */
    private $EarliestHistoryDate;

    /**
     * @var bool
     */
    private $IsDeliveryCustomer;

    /**
     * @var bool
     */
    private $IsInvoiceCustomer;

    /**
     * @var string
     */
    private $MobilePhoneNumber;

    /**
     * @var bool
     */
    private $OptedOutEmail;

    /**
     * @var string
     */
    private $PhoneNumber;

    /**
     * @var string
     */
    private $PostCity;

    /**
     * @var string
     */
    private $PostCountry;

    /**
     * @var string
     */
    private $PostPostalCode;

    /**
     * @var string
     */
    private $PostStreetAddress;

    /**
     * @var string
     */
    private $PostalCode;

    /**
     * @var string
     */
    private $ProductType;

    /**
     * @var string
     */
    private $Sector;

    /**
     * @var string
     */
    private $StreetAddress;

    /**
     * @var string
     */
    private $SubSector;

    /**
     * @return string
     */
    public function getABCode()
    {
        return $this->ABCode;
    }

    /**
     * @param string $ABCode
     * @return BaseDataResult
     */
    public function withABCode($ABCode)
    {
        $new = clone $this;
        $new->ABCode = $ABCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getApplication()
    {
        return $this->Application;
    }

    /**
     * @param string $Application
     * @return BaseDataResult
     */
    public function withApplication($Application)
    {
        $new = clone $this;
        $new->Application = $Application;

        return $new;
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->City;
    }

    /**
     * @param string $City
     * @return BaseDataResult
     */
    public function withCity($City)
    {
        $new = clone $this;
        $new->City = $City;

        return $new;
    }

    /**
     * @return string
     */
    public function getCountry()
    {
        return $this->Country;
    }

    /**
     * @param string $Country
     * @return BaseDataResult
     */
    public function withCountry($Country)
    {
        $new = clone $this;
        $new->Country = $Country;

        return $new;
    }

    /**
     * @return string
     */
    public function getCustomerName()
    {
        return $this->CustomerName;
    }

    /**
     * @param string $CustomerName
     * @return BaseDataResult
     */
    public function withCustomerName($CustomerName)
    {
        $new = clone $this;
        $new->CustomerName = $CustomerName;

        return $new;
    }

    /**
     * @return string
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }

    /**
     * @param string $CustomerNumber
     * @return BaseDataResult
     */
    public function withCustomerNumber($CustomerNumber)
    {
        $new = clone $this;
        $new->CustomerNumber = $CustomerNumber;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getEarliestHistoryDate()
    {
        return $this->EarliestHistoryDate;
    }

    /**
     * @param \DateTimeInterface $EarliestHistoryDate
     * @return BaseDataResult
     */
    public function withEarliestHistoryDate($EarliestHistoryDate)
    {
        $new = clone $this;
        $new->EarliestHistoryDate = $EarliestHistoryDate;

        return $new;
    }

    /**
     * @return bool
     */
    public function getIsDeliveryCustomer()
    {
        return $this->IsDeliveryCustomer;
    }

    /**
     * @param bool $IsDeliveryCustomer
     * @return BaseDataResult
     */
    public function withIsDeliveryCustomer($IsDeliveryCustomer)
    {
        $new = clone $this;
        $new->IsDeliveryCustomer = $IsDeliveryCustomer;

        return $new;
    }

    /**
     * @return bool
     */
    public function getIsInvoiceCustomer()
    {
        return $this->IsInvoiceCustomer;
    }

    /**
     * @param bool $IsInvoiceCustomer
     * @return BaseDataResult
     */
    public function withIsInvoiceCustomer($IsInvoiceCustomer)
    {
        $new = clone $this;
        $new->IsInvoiceCustomer = $IsInvoiceCustomer;

        return $new;
    }

    /**
     * @return string
     */
    public function getMobilePhoneNumber()
    {
        return $this->MobilePhoneNumber;
    }

    /**
     * @param string $MobilePhoneNumber
     * @return BaseDataResult
     */
    public function withMobilePhoneNumber($MobilePhoneNumber)
    {
        $new = clone $this;
        $new->MobilePhoneNumber = $MobilePhoneNumber;

        return $new;
    }

    /**
     * @return bool
     */
    public function getOptedOutEmail()
    {
        return $this->OptedOutEmail;
    }

    /**
     * @param bool $OptedOutEmail
     * @return BaseDataResult
     */
    public function withOptedOutEmail($OptedOutEmail)
    {
        $new = clone $this;
        $new->OptedOutEmail = $OptedOutEmail;

        return $new;
    }

    /**
     * @return string
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }

    /**
     * @param string $PhoneNumber
     * @return BaseDataResult
     */
    public function withPhoneNumber($PhoneNumber)
    {
        $new = clone $this;
        $new->PhoneNumber = $PhoneNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getPostCity()
    {
        return $this->PostCity;
    }

    /**
     * @param string $PostCity
     * @return BaseDataResult
     */
    public function withPostCity($PostCity)
    {
        $new = clone $this;
        $new->PostCity = $PostCity;

        return $new;
    }

    /**
     * @return string
     */
    public function getPostCountry()
    {
        return $this->PostCountry;
    }

    /**
     * @param string $PostCountry
     * @return BaseDataResult
     */
    public function withPostCountry($PostCountry)
    {
        $new = clone $this;
        $new->PostCountry = $PostCountry;

        return $new;
    }

    /**
     * @return string
     */
    public function getPostPostalCode()
    {
        return $this->PostPostalCode;
    }

    /**
     * @param string $PostPostalCode
     * @return BaseDataResult
     */
    public function withPostPostalCode($PostPostalCode)
    {
        $new = clone $this;
        $new->PostPostalCode = $PostPostalCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getPostStreetAddress()
    {
        return $this->PostStreetAddress;
    }

    /**
     * @param string $PostStreetAddress
     * @return BaseDataResult
     */
    public function withPostStreetAddress($PostStreetAddress)
    {
        $new = clone $this;
        $new->PostStreetAddress = $PostStreetAddress;

        return $new;
    }

    /**
     * @return string
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }

    /**
     * @param string $PostalCode
     * @return BaseDataResult
     */
    public function withPostalCode($PostalCode)
    {
        $new = clone $this;
        $new->PostalCode = $PostalCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getProductType()
    {
        return $this->ProductType;
    }

    /**
     * @param string $ProductType
     * @return BaseDataResult
     */
    public function withProductType($ProductType)
    {
        $new = clone $this;
        $new->ProductType = $ProductType;

        return $new;
    }

    /**
     * @return string
     */
    public function getSector()
    {
        return $this->Sector;
    }

    /**
     * @param string $Sector
     * @return BaseDataResult
     */
    public function withSector($Sector)
    {
        $new = clone $this;
        $new->Sector = $Sector;

        return $new;
    }

    /**
     * @return string
     */
    public function getStreetAddress()
    {
        return $this->StreetAddress;
    }

    /**
     * @param string $StreetAddress
     * @return BaseDataResult
     */
    public function withStreetAddress($StreetAddress)
    {
        $new = clone $this;
        $new->StreetAddress = $StreetAddress;

        return $new;
    }

    /**
     * @return string
     */
    public function getSubSector()
    {
        return $this->SubSector;
    }

    /**
     * @param string $SubSector
     * @return BaseDataResult
     */
    public function withSubSector($SubSector)
    {
        $new = clone $this;
        $new->SubSector = $SubSector;

        return $new;
    }
}
