<?php

namespace MSML\BizTalk\Base\Type;

class ContactResult
{
    /**
     * @var \DateTimeInterface
     */
    private $BirthDate;

    /**
     * @var string
     */
    private $ContactId;

    /**
     * @var string
     */
    private $ContactPersonStatus;

    /**
     * @var bool
     */
    private $DoNotCall;

    /**
     * @var string
     */
    private $Email;

    /**
     * @var string
     */
    private $ErrorMesage;

    /**
     * @var string
     */
    private $FirstName;

    /**
     * @var bool
     */
    private $HasOptedOutOfEmail;

    /**
     * @var string
     */
    private $Language;

    /**
     * @var string
     */
    private $LastName;

    /**
     * @var string
     */
    private $MobilePhone;

    /**
     * @var string
     */
    private $MyPrimagazAccountStatus;

    /**
     * @var string
     */
    private $NavisionNumber;

    /**
     * @var string
     */
    private $Phone;

    /**
     * @var string
     */
    private $Salutation;

    /**
     * @return \DateTimeInterface
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }

    /**
     * @param \DateTimeInterface $BirthDate
     * @return ContactResult
     */
    public function withBirthDate($BirthDate)
    {
        $new = clone $this;
        $new->BirthDate = $BirthDate;

        return $new;
    }

    /**
     * @return string
     */
    public function getContactId()
    {
        return $this->ContactId;
    }

    /**
     * @param string $ContactId
     * @return ContactResult
     */
    public function withContactId($ContactId)
    {
        $new = clone $this;
        $new->ContactId = $ContactId;

        return $new;
    }

    /**
     * @return string
     */
    public function getContactPersonStatus()
    {
        return $this->ContactPersonStatus;
    }

    /**
     * @param string $ContactPersonStatus
     * @return ContactResult
     */
    public function withContactPersonStatus($ContactPersonStatus)
    {
        $new = clone $this;
        $new->ContactPersonStatus = $ContactPersonStatus;

        return $new;
    }

    /**
     * @return bool
     */
    public function getDoNotCall()
    {
        return $this->DoNotCall;
    }

    /**
     * @param bool $DoNotCall
     * @return ContactResult
     */
    public function withDoNotCall($DoNotCall)
    {
        $new = clone $this;
        $new->DoNotCall = $DoNotCall;

        return $new;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->Email;
    }

    /**
     * @param string $Email
     * @return ContactResult
     */
    public function withEmail($Email)
    {
        $new = clone $this;
        $new->Email = $Email;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMesage()
    {
        return $this->ErrorMesage;
    }

    /**
     * @param string $ErrorMesage
     * @return ContactResult
     */
    public function withErrorMesage($ErrorMesage)
    {
        $new = clone $this;
        $new->ErrorMesage = $ErrorMesage;

        return $new;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }

    /**
     * @param string $FirstName
     * @return ContactResult
     */
    public function withFirstName($FirstName)
    {
        $new = clone $this;
        $new->FirstName = $FirstName;

        return $new;
    }

    /**
     * @return bool
     */
    public function getHasOptedOutOfEmail()
    {
        return $this->HasOptedOutOfEmail;
    }

    /**
     * @param bool $HasOptedOutOfEmail
     * @return ContactResult
     */
    public function withHasOptedOutOfEmail($HasOptedOutOfEmail)
    {
        $new = clone $this;
        $new->HasOptedOutOfEmail = $HasOptedOutOfEmail;

        return $new;
    }

    /**
     * @return string
     */
    public function getLanguage()
    {
        return $this->Language;
    }

    /**
     * @param string $Language
     * @return ContactResult
     */
    public function withLanguage($Language)
    {
        $new = clone $this;
        $new->Language = $Language;

        return $new;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->LastName;
    }

    /**
     * @param string $LastName
     * @return ContactResult
     */
    public function withLastName($LastName)
    {
        $new = clone $this;
        $new->LastName = $LastName;

        return $new;
    }

    /**
     * @return string
     */
    public function getMobilePhone()
    {
        return $this->MobilePhone;
    }

    /**
     * @param string $MobilePhone
     * @return ContactResult
     */
    public function withMobilePhone($MobilePhone)
    {
        $new = clone $this;
        $new->MobilePhone = $MobilePhone;

        return $new;
    }

    /**
     * @return string
     */
    public function getMyPrimagazAccountStatus()
    {
        return $this->MyPrimagazAccountStatus;
    }

    /**
     * @param string $MyPrimagazAccountStatus
     * @return ContactResult
     */
    public function withMyPrimagazAccountStatus($MyPrimagazAccountStatus)
    {
        $new = clone $this;
        $new->MyPrimagazAccountStatus = $MyPrimagazAccountStatus;

        return $new;
    }

    /**
     * @return string
     */
    public function getNavisionNumber()
    {
        return $this->NavisionNumber;
    }

    /**
     * @param string $NavisionNumber
     * @return ContactResult
     */
    public function withNavisionNumber($NavisionNumber)
    {
        $new = clone $this;
        $new->NavisionNumber = $NavisionNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getPhone()
    {
        return $this->Phone;
    }

    /**
     * @param string $Phone
     * @return ContactResult
     */
    public function withPhone($Phone)
    {
        $new = clone $this;
        $new->Phone = $Phone;

        return $new;
    }

    /**
     * @return string
     */
    public function getSalutation()
    {
        return $this->Salutation;
    }

    /**
     * @param string $Salutation
     * @return ContactResult
     */
    public function withSalutation($Salutation)
    {
        $new = clone $this;
        $new->Salutation = $Salutation;

        return $new;
    }
}
