<?php

namespace MSML\BizTalk\Base\Type;

class CustomerDataQuery
{
    /**
     * @var string
     */
    private $CustomerCode;

    /**
     * @var string
     */
    private $Division;

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }

    /**
     * @param string $CustomerCode
     * @return CustomerDataQuery
     */
    public function withCustomerCode($CustomerCode)
    {
        $new = clone $this;
        $new->CustomerCode = $CustomerCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getDivision()
    {
        return $this->Division;
    }

    /**
     * @param string $Division
     * @return CustomerDataQuery
     */
    public function withDivision($Division)
    {
        $new = clone $this;
        $new->Division = $Division;

        return $new;
    }
}
