<?php

namespace MSML\BizTalk\Base\Type;

class CustomerDataResult
{
    /**
     * @var \MSML\BizTalk\Base\Type\CustomerData
     */
    private $CustomerData;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var string
     */
    private $ReturnCode;

    /**
     * @return \MSML\BizTalk\Base\Type\CustomerData
     */
    public function getCustomerData()
    {
        return $this->CustomerData;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\CustomerData $CustomerData
     * @return CustomerDataResult
     */
    public function withCustomerData($CustomerData)
    {
        $new = clone $this;
        $new->CustomerData = $CustomerData;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return CustomerDataResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }

    /**
     * @param string $ReturnCode
     * @return CustomerDataResult
     */
    public function withReturnCode($ReturnCode)
    {
        $new = clone $this;
        $new->ReturnCode = $ReturnCode;

        return $new;
    }
}
