<?php

namespace MSML\BizTalk\Base\Type;

class CustomerLedgerEntry
{
    /**
     * @var float
     */
    private $Amount;

    /**
     * @var \DateTimeInterface
     */
    private $DocumentDate;

    /**
     * @var string
     */
    private $DocumentNo;

    /**
     * @var int
     */
    private $DocumentType;

    /**
     * @var \DateTimeInterface
     */
    private $DueDate;

    /**
     * @var int
     */
    private $InvoiceType;

    /**
     * @var bool
     */
    private $IsFromOldNavision;

    /**
     * @var string
     */
    private $OBTCStructMessage;

    /**
     * @var \DateTimeInterface
     */
    private $PostingDate;

    /**
     * @var float
     */
    private $RemainingAmount;

    /**
     * @var string
     */
    private $ReminderTermsCode;

    /**
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }

    /**
     * @param float $Amount
     * @return CustomerLedgerEntry
     */
    public function withAmount($Amount)
    {
        $new = clone $this;
        $new->Amount = $Amount;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getDocumentDate()
    {
        return $this->DocumentDate;
    }

    /**
     * @param \DateTimeInterface $DocumentDate
     * @return CustomerLedgerEntry
     */
    public function withDocumentDate($DocumentDate)
    {
        $new = clone $this;
        $new->DocumentDate = $DocumentDate;

        return $new;
    }

    /**
     * @return string
     */
    public function getDocumentNo()
    {
        return $this->DocumentNo;
    }

    /**
     * @param string $DocumentNo
     * @return CustomerLedgerEntry
     */
    public function withDocumentNo($DocumentNo)
    {
        $new = clone $this;
        $new->DocumentNo = $DocumentNo;

        return $new;
    }

    /**
     * @return int
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }

    /**
     * @param int $DocumentType
     * @return CustomerLedgerEntry
     */
    public function withDocumentType($DocumentType)
    {
        $new = clone $this;
        $new->DocumentType = $DocumentType;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getDueDate()
    {
        return $this->DueDate;
    }

    /**
     * @param \DateTimeInterface $DueDate
     * @return CustomerLedgerEntry
     */
    public function withDueDate($DueDate)
    {
        $new = clone $this;
        $new->DueDate = $DueDate;

        return $new;
    }

    /**
     * @return int
     */
    public function getInvoiceType()
    {
        return $this->InvoiceType;
    }

    /**
     * @param int $InvoiceType
     * @return CustomerLedgerEntry
     */
    public function withInvoiceType($InvoiceType)
    {
        $new = clone $this;
        $new->InvoiceType = $InvoiceType;

        return $new;
    }

    /**
     * @return bool
     */
    public function getIsFromOldNavision()
    {
        return $this->IsFromOldNavision;
    }

    /**
     * @param bool $IsFromOldNavision
     * @return CustomerLedgerEntry
     */
    public function withIsFromOldNavision($IsFromOldNavision)
    {
        $new = clone $this;
        $new->IsFromOldNavision = $IsFromOldNavision;

        return $new;
    }

    /**
     * @return string
     */
    public function getOBTCStructMessage()
    {
        return $this->OBTCStructMessage;
    }

    /**
     * @param string $OBTCStructMessage
     * @return CustomerLedgerEntry
     */
    public function withOBTCStructMessage($OBTCStructMessage)
    {
        $new = clone $this;
        $new->OBTCStructMessage = $OBTCStructMessage;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getPostingDate()
    {
        return $this->PostingDate;
    }

    /**
     * @param \DateTimeInterface $PostingDate
     * @return CustomerLedgerEntry
     */
    public function withPostingDate($PostingDate)
    {
        $new = clone $this;
        $new->PostingDate = $PostingDate;

        return $new;
    }

    /**
     * @return float
     */
    public function getRemainingAmount()
    {
        return $this->RemainingAmount;
    }

    /**
     * @param float $RemainingAmount
     * @return CustomerLedgerEntry
     */
    public function withRemainingAmount($RemainingAmount)
    {
        $new = clone $this;
        $new->RemainingAmount = $RemainingAmount;

        return $new;
    }

    /**
     * @return string
     */
    public function getReminderTermsCode()
    {
        return $this->ReminderTermsCode;
    }

    /**
     * @param string $ReminderTermsCode
     * @return CustomerLedgerEntry
     */
    public function withReminderTermsCode($ReminderTermsCode)
    {
        $new = clone $this;
        $new->ReminderTermsCode = $ReminderTermsCode;

        return $new;
    }
}
