<?php

namespace MSML\BizTalk\Base\Type;

class Document
{
    /**
     * @var string
     */
    private $Content;

    /**
     * @var \MSML\BizTalk\Base\Type\Information
     */
    private $Information;

    /**
     * @return string
     */
    public function getContent()
    {
        return $this->Content;
    }

    /**
     * @param string $Content
     * @return Document
     */
    public function withContent($Content)
    {
        $new = clone $this;
        $new->Content = $Content;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Base\Type\Information
     */
    public function getInformation()
    {
        return $this->Information;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\Information $Information
     * @return Document
     */
    public function withInformation($Information)
    {
        $new = clone $this;
        $new->Information = $Information;

        return $new;
    }
}
