<?php

namespace MSML\BizTalk\Base\Type;

class DocumentNotFoundFault
{
    /**
     * @var string
     */
    private $Message;

    /**
     * @var string
     */
    private $Reason;

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->Message;
    }

    /**
     * @param string $Message
     * @return DocumentNotFoundFault
     */
    public function withMessage($Message)
    {
        $new = clone $this;
        $new->Message = $Message;

        return $new;
    }

    /**
     * @return string
     */
    public function getReason()
    {
        return $this->Reason;
    }

    /**
     * @param string $Reason
     * @return DocumentNotFoundFault
     */
    public function withReason($Reason)
    {
        $new = clone $this;
        $new->Reason = $Reason;

        return $new;
    }
}
