<?php

namespace MSML\BizTalk\Base\Type;

class FuelTankHistory
{
    /**
     * @var \MSML\BizTalk\Base\Type\ArrayOfPeriod
     */
    private $Periods;

    /**
     * @var int
     */
    private $ShipToAddressCode;

    /**
     * @var string
     */
    private $TankNo;

    /**
     * @var string
     */
    private $TankUOM;

    /**
     * @var string
     */
    private $TelemetryID;

    /**
     * @return \MSML\BizTalk\Base\Type\ArrayOfPeriod
     */
    public function getPeriods()
    {
        return $this->Periods;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\ArrayOfPeriod $Periods
     * @return FuelTankHistory
     */
    public function withPeriods($Periods)
    {
        $new = clone $this;
        $new->Periods = $Periods;

        return $new;
    }

    /**
     * @return int
     */
    public function getShipToAddressCode()
    {
        return $this->ShipToAddressCode;
    }

    /**
     * @param int $ShipToAddressCode
     * @return FuelTankHistory
     */
    public function withShipToAddressCode($ShipToAddressCode)
    {
        $new = clone $this;
        $new->ShipToAddressCode = $ShipToAddressCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getTankNo()
    {
        return $this->TankNo;
    }

    /**
     * @param string $TankNo
     * @return FuelTankHistory
     */
    public function withTankNo($TankNo)
    {
        $new = clone $this;
        $new->TankNo = $TankNo;

        return $new;
    }

    /**
     * @return string
     */
    public function getTankUOM()
    {
        return $this->TankUOM;
    }

    /**
     * @param string $TankUOM
     * @return FuelTankHistory
     */
    public function withTankUOM($TankUOM)
    {
        $new = clone $this;
        $new->TankUOM = $TankUOM;

        return $new;
    }

    /**
     * @return string
     */
    public function getTelemetryID()
    {
        return $this->TelemetryID;
    }

    /**
     * @param string $TelemetryID
     * @return FuelTankHistory
     */
    public function withTelemetryID($TelemetryID)
    {
        $new = clone $this;
        $new->TelemetryID = $TelemetryID;

        return $new;
    }
}
