<?php

namespace MSML\BizTalk\Base\Type;

class FuelTankResult
{
    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var \MSML\BizTalk\Base\Type\DRRException
     */
    private $Exception;

    /**
     * @var \MSML\BizTalk\Base\Type\ArrayOfFuelTankResultFuelTank
     */
    private $FuelTanks;

    /**
     * @var string
     */
    private $ReturnCode;

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return FuelTankResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Base\Type\DRRException
     */
    public function getException()
    {
        return $this->Exception;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\DRRException $Exception
     * @return FuelTankResult
     */
    public function withException($Exception)
    {
        $new = clone $this;
        $new->Exception = $Exception;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Base\Type\ArrayOfFuelTankResultFuelTank
     */
    public function getFuelTanks()
    {
        return $this->FuelTanks;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\ArrayOfFuelTankResultFuelTank $FuelTanks
     * @return FuelTankResult
     */
    public function withFuelTanks($FuelTanks)
    {
        $new = clone $this;
        $new->FuelTanks = $FuelTanks;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }

    /**
     * @param string $ReturnCode
     * @return FuelTankResult
     */
    public function withReturnCode($ReturnCode)
    {
        $new = clone $this;
        $new->ReturnCode = $ReturnCode;

        return $new;
    }
}
