<?php

namespace MSML\BizTalk\Base\Type;

class GasMeterInfo
{
    /**
     * @var bool
     */
    private $Correction;

    /**
     * @var float
     */
    private $Difference;

    /**
     * @var \DateTimeInterface
     */
    private $EndDate;

    /**
     * @var float
     */
    private $EndScore;

    /**
     * @var bool
     */
    private $Expected;

    /**
     * @var string
     */
    private $GasmeterNo;

    /**
     * @var string
     */
    private $RecordingType;

    /**
     * @var string
     */
    private $ServiceItemNo;

    /**
     * @var \DateTimeInterface
     */
    private $StartDate;

    /**
     * @var float
     */
    private $StartScore;

    /**
     * @var string
     */
    private $Type;

    /**
     * @return bool
     */
    public function getCorrection()
    {
        return $this->Correction;
    }

    /**
     * @param bool $Correction
     * @return GasMeterInfo
     */
    public function withCorrection($Correction)
    {
        $new = clone $this;
        $new->Correction = $Correction;

        return $new;
    }

    /**
     * @return float
     */
    public function getDifference()
    {
        return $this->Difference;
    }

    /**
     * @param float $Difference
     * @return GasMeterInfo
     */
    public function withDifference($Difference)
    {
        $new = clone $this;
        $new->Difference = $Difference;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }

    /**
     * @param \DateTimeInterface $EndDate
     * @return GasMeterInfo
     */
    public function withEndDate($EndDate)
    {
        $new = clone $this;
        $new->EndDate = $EndDate;

        return $new;
    }

    /**
     * @return float
     */
    public function getEndScore()
    {
        return $this->EndScore;
    }

    /**
     * @param float $EndScore
     * @return GasMeterInfo
     */
    public function withEndScore($EndScore)
    {
        $new = clone $this;
        $new->EndScore = $EndScore;

        return $new;
    }

    /**
     * @return bool
     */
    public function getExpected()
    {
        return $this->Expected;
    }

    /**
     * @param bool $Expected
     * @return GasMeterInfo
     */
    public function withExpected($Expected)
    {
        $new = clone $this;
        $new->Expected = $Expected;

        return $new;
    }

    /**
     * @return string
     */
    public function getGasmeterNo()
    {
        return $this->GasmeterNo;
    }

    /**
     * @param string $GasmeterNo
     * @return GasMeterInfo
     */
    public function withGasmeterNo($GasmeterNo)
    {
        $new = clone $this;
        $new->GasmeterNo = $GasmeterNo;

        return $new;
    }

    /**
     * @return string
     */
    public function getRecordingType()
    {
        return $this->RecordingType;
    }

    /**
     * @param string $RecordingType
     * @return GasMeterInfo
     */
    public function withRecordingType($RecordingType)
    {
        $new = clone $this;
        $new->RecordingType = $RecordingType;

        return $new;
    }

    /**
     * @return string
     */
    public function getServiceItemNo()
    {
        return $this->ServiceItemNo;
    }

    /**
     * @param string $ServiceItemNo
     * @return GasMeterInfo
     */
    public function withServiceItemNo($ServiceItemNo)
    {
        $new = clone $this;
        $new->ServiceItemNo = $ServiceItemNo;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }

    /**
     * @param \DateTimeInterface $StartDate
     * @return GasMeterInfo
     */
    public function withStartDate($StartDate)
    {
        $new = clone $this;
        $new->StartDate = $StartDate;

        return $new;
    }

    /**
     * @return float
     */
    public function getStartScore()
    {
        return $this->StartScore;
    }

    /**
     * @param float $StartScore
     * @return GasMeterInfo
     */
    public function withStartScore($StartScore)
    {
        $new = clone $this;
        $new->StartScore = $StartScore;

        return $new;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }

    /**
     * @param string $Type
     * @return GasMeterInfo
     */
    public function withType($Type)
    {
        $new = clone $this;
        $new->Type = $Type;

        return $new;
    }
}
