<?php

namespace MSML\BizTalk\Base\Type;

class GasMeterInfoQuery
{
    /**
     * @var string
     */
    private $CustomerNumber;

    /**
     * @var string
     */
    private $Division;

    /**
     * @return string
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }

    /**
     * @param string $CustomerNumber
     * @return GasMeterInfoQuery
     */
    public function withCustomerNumber($CustomerNumber)
    {
        $new = clone $this;
        $new->CustomerNumber = $CustomerNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getDivision()
    {
        return $this->Division;
    }

    /**
     * @param string $Division
     * @return GasMeterInfoQuery
     */
    public function withDivision($Division)
    {
        $new = clone $this;
        $new->Division = $Division;

        return $new;
    }
}
