<?php

namespace MSML\BizTalk\Base\Type;

class GasMeterInfoResult
{
    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var \MSML\BizTalk\Base\Type\ArrayOfGasMeterInfo
     */
    private $GasMeterInfos;

    /**
     * @var string
     */
    private $ReturnCode;

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GasMeterInfoResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Base\Type\ArrayOfGasMeterInfo
     */
    public function getGasMeterInfos()
    {
        return $this->GasMeterInfos;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\ArrayOfGasMeterInfo $GasMeterInfos
     * @return GasMeterInfoResult
     */
    public function withGasMeterInfos($GasMeterInfos)
    {
        $new = clone $this;
        $new->GasMeterInfos = $GasMeterInfos;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }

    /**
     * @param string $ReturnCode
     * @return GasMeterInfoResult
     */
    public function withReturnCode($ReturnCode)
    {
        $new = clone $this;
        $new->ReturnCode = $ReturnCode;

        return $new;
    }
}
