<?php

namespace MSML\BizTalk\Base\Type;

class GetBasicDataQuery
{
    /**
     * @var string
     */
    private $CustomerNumber;

    /**
     * @var string
     */
    private $LanguageCode;

    /**
     * @return string
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }

    /**
     * @param string $CustomerNumber
     * @return GetBasicDataQuery
     */
    public function withCustomerNumber($CustomerNumber)
    {
        $new = clone $this;
        $new->CustomerNumber = $CustomerNumber;

        return $new;
    }

    /**
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }

    /**
     * @param string $LanguageCode
     * @return GetBasicDataQuery
     */
    public function withLanguageCode($LanguageCode)
    {
        $new = clone $this;
        $new->LanguageCode = $LanguageCode;

        return $new;
    }
}
