<?php

namespace MSML\BizTalk\Base\Type;

class GetBasicDataResult
{
    /**
     * @var \MSML\BizTalk\Base\Type\ArrayOfBaseDataResult
     */
    private $DeliveryCustomers;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @return \MSML\BizTalk\Base\Type\ArrayOfBaseDataResult
     */
    public function getDeliveryCustomers()
    {
        return $this->DeliveryCustomers;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\ArrayOfBaseDataResult $DeliveryCustomers
     * @return GetBasicDataResult
     */
    public function withDeliveryCustomers($DeliveryCustomers)
    {
        $new = clone $this;
        $new->DeliveryCustomers = $DeliveryCustomers;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetBasicDataResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }
}
