<?php

namespace MSML\BizTalk\Base\Type;

use Phpro\SoapClient\Type\RequestInterface;

class GetContact implements RequestInterface
{
    /**
     * @var \MSML\BizTalk\Base\Type\ContactQuery
     */
    private $request;

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Base\Type\ContactQuery $request
     */
    public function __construct($request)
    {
        $this->request = $request;
    }

    /**
     * @return \MSML\BizTalk\Base\Type\ContactQuery
     */
    public function getRequest()
    {
        return $this->request;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\ContactQuery $request
     * @return GetContact
     */
    public function withRequest($request)
    {
        $new = clone $this;
        $new->request = $request;

        return $new;
    }
}
