<?php

namespace MSML\BizTalk\Base\Type;

use Phpro\SoapClient\Type\RequestInterface;

class GetCustomerInfo implements RequestInterface
{
    /**
     * @var \MSML\BizTalk\Base\Type\CustomerDataQuery
     */
    private $request;

    /**
     * Constructor
     *
     * @var \MSML\BizTalk\Base\Type\CustomerDataQuery $request
     */
    public function __construct($request)
    {
        $this->request = $request;
    }

    /**
     * @return \MSML\BizTalk\Base\Type\CustomerDataQuery
     */
    public function getRequest()
    {
        return $this->request;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\CustomerDataQuery $request
     * @return GetCustomerInfo
     */
    public function withRequest($request)
    {
        $new = clone $this;
        $new->request = $request;

        return $new;
    }
}
