<?php

namespace MSML\BizTalk\Base\Type;

class GetCustomerLedgerEntryQuery
{
    /**
     * @var string
     */
    private $CustomerCode;

    /**
     * @var string
     */
    private $Division;

    /**
     * @var \DateTimeInterface
     */
    private $EarliestHistoryDate;

    /**
     * @var string
     */
    private $OldCustomerNumber;

    /**
     * @var bool
     */
    private $ShowOnlyOpenEntries;

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }

    /**
     * @param string $CustomerCode
     * @return GetCustomerLedgerEntryQuery
     */
    public function withCustomerCode($CustomerCode)
    {
        $new = clone $this;
        $new->CustomerCode = $CustomerCode;

        return $new;
    }

    /**
     * @return string
     */
    public function getDivision()
    {
        return $this->Division;
    }

    /**
     * @param string $Division
     * @return GetCustomerLedgerEntryQuery
     */
    public function withDivision($Division)
    {
        $new = clone $this;
        $new->Division = $Division;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getEarliestHistoryDate()
    {
        return $this->EarliestHistoryDate;
    }

    /**
     * @param \DateTimeInterface $EarliestHistoryDate
     * @return GetCustomerLedgerEntryQuery
     */
    public function withEarliestHistoryDate($EarliestHistoryDate)
    {
        $new = clone $this;
        $new->EarliestHistoryDate = $EarliestHistoryDate;

        return $new;
    }

    /**
     * @return string
     */
    public function getOldCustomerNumber()
    {
        return $this->OldCustomerNumber;
    }

    /**
     * @param string $OldCustomerNumber
     * @return GetCustomerLedgerEntryQuery
     */
    public function withOldCustomerNumber($OldCustomerNumber)
    {
        $new = clone $this;
        $new->OldCustomerNumber = $OldCustomerNumber;

        return $new;
    }

    /**
     * @return bool
     */
    public function getShowOnlyOpenEntries()
    {
        return $this->ShowOnlyOpenEntries;
    }

    /**
     * @param bool $ShowOnlyOpenEntries
     * @return GetCustomerLedgerEntryQuery
     */
    public function withShowOnlyOpenEntries($ShowOnlyOpenEntries)
    {
        $new = clone $this;
        $new->ShowOnlyOpenEntries = $ShowOnlyOpenEntries;

        return $new;
    }
}
