<?php

namespace MSML\BizTalk\Base\Type;

class GetCustomerLedgerEntryResult
{
    /**
     * @var string
     */
    private $CustomerCode;

    /**
     * @var \MSML\BizTalk\Base\Type\ArrayOfCustomerLedgerEntry
     */
    private $CustomerLedgerEntry;

    /**
     * @var string
     */
    private $ErrorMessage;

    /**
     * @var string
     */
    private $ReturnCode;

    /**
     * @var \DateTimeInterface
     */
    private $StartDate;

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }

    /**
     * @param string $CustomerCode
     * @return GetCustomerLedgerEntryResult
     */
    public function withCustomerCode($CustomerCode)
    {
        $new = clone $this;
        $new->CustomerCode = $CustomerCode;

        return $new;
    }

    /**
     * @return \MSML\BizTalk\Base\Type\ArrayOfCustomerLedgerEntry
     */
    public function getCustomerLedgerEntry()
    {
        return $this->CustomerLedgerEntry;
    }

    /**
     * @param \MSML\BizTalk\Base\Type\ArrayOfCustomerLedgerEntry $CustomerLedgerEntry
     * @return GetCustomerLedgerEntryResult
     */
    public function withCustomerLedgerEntry($CustomerLedgerEntry)
    {
        $new = clone $this;
        $new->CustomerLedgerEntry = $CustomerLedgerEntry;

        return $new;
    }

    /**
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }

    /**
     * @param string $ErrorMessage
     * @return GetCustomerLedgerEntryResult
     */
    public function withErrorMessage($ErrorMessage)
    {
        $new = clone $this;
        $new->ErrorMessage = $ErrorMessage;

        return $new;
    }

    /**
     * @return string
     */
    public function getReturnCode()
    {
        return $this->ReturnCode;
    }

    /**
     * @param string $ReturnCode
     * @return GetCustomerLedgerEntryResult
     */
    public function withReturnCode($ReturnCode)
    {
        $new = clone $this;
        $new->ReturnCode = $ReturnCode;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }

    /**
     * @param \DateTimeInterface $StartDate
     * @return GetCustomerLedgerEntryResult
     */
    public function withStartDate($StartDate)
    {
        $new = clone $this;
        $new->StartDate = $StartDate;

        return $new;
    }
}
