<?php

namespace MSML\BizTalk\Base\Type;

class GetDiscountItem
{
    /**
     * @var float
     */
    private $Amount;

    /**
     * @var string
     */
    private $Component;

    /**
     * @var string
     */
    private $ComponentDescription;

    /**
     * @var float
     */
    private $FreeGas;

    /**
     * @var \DateTimeInterface
     */
    private $From;

    /**
     * @var float
     */
    private $Minimum;

    /**
     * @var float
     */
    private $Percentage;

    /**
     * @var float
     */
    private $PumpDealerDiscount;

    /**
     * @var float
     */
    private $PumpDiscountExclVAT;

    /**
     * @var float
     */
    private $PumpDiscountInclVAT;

    /**
     * @var \DateTimeInterface
     */
    private $To;

    /**
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }

    /**
     * @param float $Amount
     * @return GetDiscountItem
     */
    public function withAmount($Amount)
    {
        $new = clone $this;
        $new->Amount = $Amount;

        return $new;
    }

    /**
     * @return string
     */
    public function getComponent()
    {
        return $this->Component;
    }

    /**
     * @param string $Component
     * @return GetDiscountItem
     */
    public function withComponent($Component)
    {
        $new = clone $this;
        $new->Component = $Component;

        return $new;
    }

    /**
     * @return string
     */
    public function getComponentDescription()
    {
        return $this->ComponentDescription;
    }

    /**
     * @param string $ComponentDescription
     * @return GetDiscountItem
     */
    public function withComponentDescription($ComponentDescription)
    {
        $new = clone $this;
        $new->ComponentDescription = $ComponentDescription;

        return $new;
    }

    /**
     * @return float
     */
    public function getFreeGas()
    {
        return $this->FreeGas;
    }

    /**
     * @param float $FreeGas
     * @return GetDiscountItem
     */
    public function withFreeGas($FreeGas)
    {
        $new = clone $this;
        $new->FreeGas = $FreeGas;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getFrom()
    {
        return $this->From;
    }

    /**
     * @param \DateTimeInterface $From
     * @return GetDiscountItem
     */
    public function withFrom($From)
    {
        $new = clone $this;
        $new->From = $From;

        return $new;
    }

    /**
     * @return float
     */
    public function getMinimum()
    {
        return $this->Minimum;
    }

    /**
     * @param float $Minimum
     * @return GetDiscountItem
     */
    public function withMinimum($Minimum)
    {
        $new = clone $this;
        $new->Minimum = $Minimum;

        return $new;
    }

    /**
     * @return float
     */
    public function getPercentage()
    {
        return $this->Percentage;
    }

    /**
     * @param float $Percentage
     * @return GetDiscountItem
     */
    public function withPercentage($Percentage)
    {
        $new = clone $this;
        $new->Percentage = $Percentage;

        return $new;
    }

    /**
     * @return float
     */
    public function getPumpDealerDiscount()
    {
        return $this->PumpDealerDiscount;
    }

    /**
     * @param float $PumpDealerDiscount
     * @return GetDiscountItem
     */
    public function withPumpDealerDiscount($PumpDealerDiscount)
    {
        $new = clone $this;
        $new->PumpDealerDiscount = $PumpDealerDiscount;

        return $new;
    }

    /**
     * @return float
     */
    public function getPumpDiscountExclVAT()
    {
        return $this->PumpDiscountExclVAT;
    }

    /**
     * @param float $PumpDiscountExclVAT
     * @return GetDiscountItem
     */
    public function withPumpDiscountExclVAT($PumpDiscountExclVAT)
    {
        $new = clone $this;
        $new->PumpDiscountExclVAT = $PumpDiscountExclVAT;

        return $new;
    }

    /**
     * @return float
     */
    public function getPumpDiscountInclVAT()
    {
        return $this->PumpDiscountInclVAT;
    }

    /**
     * @param float $PumpDiscountInclVAT
     * @return GetDiscountItem
     */
    public function withPumpDiscountInclVAT($PumpDiscountInclVAT)
    {
        $new = clone $this;
        $new->PumpDiscountInclVAT = $PumpDiscountInclVAT;

        return $new;
    }

    /**
     * @return \DateTimeInterface
     */
    public function getTo()
    {
        return $this->To;
    }

    /**
     * @param \DateTimeInterface $To
     * @return GetDiscountItem
     */
    public function withTo($To)
    {
        $new = clone $this;
        $new->To = $To;

        return $new;
    }
}
